/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.transport.services.util;

import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LatencyViewStatistics {
    private static final Log log = LogFactory.getLog(LatencyViewStatistics.class);
    private double nioHttpAllTimeAvgLatency;
    private double nioHttpLast15MinuteAvgLatency;
    private double nioHttpLast24HourAvgLatency;
    private double nioHttpLast5MinuteAvgLatency;
    private double nioHttpLast8HourAvgLatency;
    private double nioHttpLastHourAvgLatency;
    private double nioHttpLastMinuteAvgLatency;
    private String nioHttpLastResetTime;
    private double nioHttpsAllTimeAvgLatency;
    private double nioHttpsLast15MinuteAvgLatency;
    private double nioHttpsLast24HourAvgLatency;
    private double nioHttpsLast5MinuteAvgLatency;
    private double nioHttpsLast8HourAvgLatency;
    private double nioHttpsLastHourAvgLatency;
    private double nioHttpsLastMinuteAvgLatency;
    private String nioHttpsLastResetTime;

    public LatencyViewStatistics(MBeanServer server) {
        this.updateNioHttpStats(server);
        this.updateNioHttpsStats(server);
    }

    private void updateNioHttpStats(MBeanServer server) {
        ObjectName clientWorkerObjectName = null;
        try {
            clientWorkerObjectName = new ObjectName("org.apache.synapse:Type=NhttpTransportLatency,Name=nio-http");
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)"Malformed Object Name for MBean", (Throwable)e);
        }
        String[] clientWorkerAttributes = new String[]{"AllTimeAvgLatency", "Last15MinuteAvgLatency", "Last24HourAvgLatency", "Last5MinuteAvgLatency", "Last8HourAvgLatency", "LastHourAvgLatency", "LastMinuteAvgLatency", "LastResetTime"};
        AttributeList list = null;
        try {
            list = server.getAttributes(clientWorkerObjectName, clientWorkerAttributes);
        }
        catch (InstanceNotFoundException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        catch (ReflectionException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (list != null) {
            for (Object obj : list) {
                String[] keyValueArray = obj.toString().split("=");
                ht.put(keyValueArray[0], keyValueArray[1]);
            }
        }
        this.setNioHttpAllTimeAvgLatency(Double.parseDouble((String)ht.get("AllTimeAvgLatency")));
        this.setNioHttpLast15MinuteAvgLatency(Double.parseDouble((String)ht.get("Last15MinuteAvgLatency")));
        this.setNioHttpLast24HourAvgLatency(Double.parseDouble((String)ht.get("Last24HourAvgLatency")));
        this.setNioHttpLast5MinuteAvgLatency(Double.parseDouble((String)ht.get("Last5MinuteAvgLatency")));
        this.setNioHttpLast8HourAvgLatency(Double.parseDouble((String)ht.get("Last8HourAvgLatency")));
        this.setNioHttpLastHourAvgLatency(Double.parseDouble((String)ht.get("LastHourAvgLatency")));
        this.setNioHttpLastMinuteAvgLatency(Double.parseDouble((String)ht.get("LastMinuteAvgLatency")));
        this.setNioHttpLastResetTime("LastResetTime");
    }

    private void updateNioHttpsStats(MBeanServer server) {
        ObjectName clientWorkerObjectName = null;
        try {
            clientWorkerObjectName = new ObjectName("org.apache.synapse:Type=NhttpTransportLatency,Name=nio-https");
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)"Malformed Object Name for MBean", (Throwable)e);
        }
        String[] clientWorkerAttributes = new String[]{"AllTimeAvgLatency", "Last15MinuteAvgLatency", "Last24HourAvgLatency", "Last5MinuteAvgLatency", "Last8HourAvgLatency", "LastHourAvgLatency", "LastMinuteAvgLatency", "LastResetTime"};
        AttributeList list = null;
        try {
            list = server.getAttributes(clientWorkerObjectName, clientWorkerAttributes);
        }
        catch (InstanceNotFoundException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        catch (ReflectionException e) {
            log.warn((Object)"Could not retrieve attributes for MBean", (Throwable)e);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (list != null) {
            for (Object obj : list) {
                String[] keyValueArray = obj.toString().split("=");
                ht.put(keyValueArray[0], keyValueArray[1]);
            }
        }
        this.setNioHttpsAllTimeAvgLatency(Double.parseDouble((String)ht.get("AllTimeAvgLatency")));
        this.setNioHttpsLast15MinuteAvgLatency(Double.parseDouble((String)ht.get("Last15MinuteAvgLatency")));
        this.setNioHttpsLast24HourAvgLatency(Double.parseDouble((String)ht.get("Last24HourAvgLatency")));
        this.setNioHttpsLast5MinuteAvgLatency(Double.parseDouble((String)ht.get("Last5MinuteAvgLatency")));
        this.setNioHttpsLast8HourAvgLatency(Double.parseDouble((String)ht.get("Last8HourAvgLatency")));
        this.setNioHttpsLastHourAvgLatency(Double.parseDouble((String)ht.get("LastHourAvgLatency")));
        this.setNioHttpsLastMinuteAvgLatency(Double.parseDouble((String)ht.get("LastMinuteAvgLatency")));
        this.setNioHttpsLastResetTime("LastResetTime");
    }

    public double getNioHttpsAllTimeAvgLatency() {
        return this.nioHttpsAllTimeAvgLatency;
    }

    public void setNioHttpsAllTimeAvgLatency(double nioHttpsAllTimeAvgLatency) {
        this.nioHttpsAllTimeAvgLatency = nioHttpsAllTimeAvgLatency;
    }

    public double getNioHttpsLast15MinuteAvgLatency() {
        return this.nioHttpsLast15MinuteAvgLatency;
    }

    public void setNioHttpsLast15MinuteAvgLatency(double nioHttpsLast15MinuteAvgLatency) {
        this.nioHttpsLast15MinuteAvgLatency = nioHttpsLast15MinuteAvgLatency;
    }

    public double getNioHttpsLast24HourAvgLatency() {
        return this.nioHttpsLast24HourAvgLatency;
    }

    public void setNioHttpsLast24HourAvgLatency(double nioHttpsLast24HourAvgLatency) {
        this.nioHttpsLast24HourAvgLatency = nioHttpsLast24HourAvgLatency;
    }

    public double getNioHttpsLast5MinuteAvgLatency() {
        return this.nioHttpsLast5MinuteAvgLatency;
    }

    public void setNioHttpsLast5MinuteAvgLatency(double nioHttpsLast5MinuteAvgLatency) {
        this.nioHttpsLast5MinuteAvgLatency = nioHttpsLast5MinuteAvgLatency;
    }

    public double getNioHttpsLast8HourAvgLatency() {
        return this.nioHttpsLast8HourAvgLatency;
    }

    public void setNioHttpsLast8HourAvgLatency(double nioHttpsLast8HourAvgLatency) {
        this.nioHttpsLast8HourAvgLatency = nioHttpsLast8HourAvgLatency;
    }

    public double getNioHttpsLastHourAvgLatency() {
        return this.nioHttpsLastHourAvgLatency;
    }

    public void setNioHttpsLastHourAvgLatency(double nioHttpsLastHourAvgLatency) {
        this.nioHttpsLastHourAvgLatency = nioHttpsLastHourAvgLatency;
    }

    public double getNioHttpsLastMinuteAvgLatency() {
        return this.nioHttpsLastMinuteAvgLatency;
    }

    public void setNioHttpsLastMinuteAvgLatency(double nioHttpsLastMinuteAvgLatency) {
        this.nioHttpsLastMinuteAvgLatency = nioHttpsLastMinuteAvgLatency;
    }

    public String getNioHttpsLastResetTime() {
        return this.nioHttpsLastResetTime;
    }

    public void setNioHttpsLastResetTime(String nioHttpsLastResetTime) {
        this.nioHttpsLastResetTime = nioHttpsLastResetTime;
    }

    public double getNioHttpAllTimeAvgLatency() {
        return this.nioHttpAllTimeAvgLatency;
    }

    public void setNioHttpAllTimeAvgLatency(double nioHttpAllTimeAvgLatency) {
        this.nioHttpAllTimeAvgLatency = nioHttpAllTimeAvgLatency;
    }

    public double getNioHttpLast15MinuteAvgLatency() {
        return this.nioHttpLast15MinuteAvgLatency;
    }

    public void setNioHttpLast15MinuteAvgLatency(double nioHttpLast15MinuteAvgLatency) {
        this.nioHttpLast15MinuteAvgLatency = nioHttpLast15MinuteAvgLatency;
    }

    public double getNioHttpLast24HourAvgLatency() {
        return this.nioHttpLast24HourAvgLatency;
    }

    public void setNioHttpLast24HourAvgLatency(double nioHttpLast24HourAvgLatency) {
        this.nioHttpLast24HourAvgLatency = nioHttpLast24HourAvgLatency;
    }

    public double getNioHttpLast5MinuteAvgLatency() {
        return this.nioHttpLast5MinuteAvgLatency;
    }

    public void setNioHttpLast5MinuteAvgLatency(double nioHttpLast5MinuteAvgLatency) {
        this.nioHttpLast5MinuteAvgLatency = nioHttpLast5MinuteAvgLatency;
    }

    public double getNioHttpLast8HourAvgLatency() {
        return this.nioHttpLast8HourAvgLatency;
    }

    public void setNioHttpLast8HourAvgLatency(double nioHttpLast8HourAvgLatency) {
        this.nioHttpLast8HourAvgLatency = nioHttpLast8HourAvgLatency;
    }

    public double getNioHttpLastHourAvgLatency() {
        return this.nioHttpLastHourAvgLatency;
    }

    public void setNioHttpLastHourAvgLatency(double nioHttpLastHourAvgLatency) {
        this.nioHttpLastHourAvgLatency = nioHttpLastHourAvgLatency;
    }

    public double getNioHttpLastMinuteAvgLatency() {
        return this.nioHttpLastMinuteAvgLatency;
    }

    public void setNioHttpLastMinuteAvgLatency(double nioHttpLastMinuteAvgLatency) {
        this.nioHttpLastMinuteAvgLatency = nioHttpLastMinuteAvgLatency;
    }

    public String getNioHttpLastResetTime() {
        return this.nioHttpLastResetTime;
    }

    public void setNioHttpLastResetTime(String nioHttpLastResetTime) {
        this.nioHttpLastResetTime = nioHttpLastResetTime;
    }
}

