/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.statistics.transport.services;

import java.lang.management.ManagementFactory;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.ManagementSupport;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.statistics.transport.services.util.ConfigHolder;
import org.wso2.carbon.statistics.transport.services.util.LatencyViewStatistics;
import org.wso2.carbon.statistics.transport.services.util.SystemTransportStatistics;
import org.wso2.carbon.statistics.transport.services.util.ThreadViewStatistics;
import org.wso2.carbon.statistics.transport.services.util.TransportStatistics;

public class TransportStatisticsAdmin
extends AbstractAdmin {
    public String[] getExposedTransports() {
        return ConfigHolder.getInstance().getAllTransports();
    }

    public TransportStatistics getTransportStatistic(String transportName) {
        return new TransportStatistics(transportName);
    }

    public ThreadViewStatistics getThreadViewStatistics() {
        return new ThreadViewStatistics(ManagementFactory.getPlatformMBeanServer());
    }

    public LatencyViewStatistics getLatencyViewStatistics() {
        return new LatencyViewStatistics(ManagementFactory.getPlatformMBeanServer());
    }

    public SystemTransportStatistics getAllTransportStatistics() {
        String[] transports = ConfigHolder.getInstance().getAllTransports();
        SystemTransportStatistics sysTransportStat = new SystemTransportStatistics();
        for (String transport : transports) {
            sysTransportStat.addTransportStatistics(new TransportStatistics(transport));
        }
        return sysTransportStat;
    }

    public String getTransportClassName(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ConfigHolder.getInstance().getTransportListenerClassName(transportName);
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ConfigHolder.getInstance().getTransportSenderClassName(transportName);
        }
        return "";
    }

    public int getActiveThreadCount(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getActiveThreadCount();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getActiveThreadCount();
        }
        return 0;
    }

    public double getAvgSizeReceived(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getAvgSizeReceived();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getAvgSizeReceived();
        }
        return 0.0;
    }

    public double getAvgSizeSent(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getAvgSizeSent();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getAvgSizeSent();
        }
        return 0.0;
    }

    public long getBytesReceived(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getBytesReceived();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getBytesReceived();
        }
        return 0L;
    }

    public long getBytesSent(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getBytesSent();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getBytesSent();
        }
        return 0L;
    }

    public long getFaultsReceiving(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getFaultsReceiving();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getFaultsReceiving();
        }
        return 0L;
    }

    public long getFaultsSending(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getFaultsSending();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getFaultsSending();
        }
        return 0L;
    }

    public long getLastResetTime(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getLastResetTime();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getLastResetTime();
        }
        return 0L;
    }

    public long getMaxSizeReceived(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMaxSizeReceived();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMaxSizeReceived();
        }
        return 0L;
    }

    public long getMaxSizeSent(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMaxSizeSent();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMaxSizeSent();
        }
        return 0L;
    }

    public long getMessagesReceived(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMessagesReceived();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMessagesReceived();
        }
        return 0L;
    }

    public long getMessagesSent(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMessagesSent();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMessagesSent();
        }
        return 0L;
    }

    public long getMetricsWindow(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMetricsWindow();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMetricsWindow();
        }
        return 0L;
    }

    public long getMinSizeReceived(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMinSizeReceived();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMinSizeReceived();
        }
        return 0L;
    }

    public long getMinSizeSent(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getMinSizeSent();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getMinSizeSent();
        }
        return 0L;
    }

    public int getQueueSize(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getQueueSize();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getQueueSize();
        }
        return 0;
    }

    public long getTimeoutsReceiving(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getTimeoutsReceiving();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getTimeoutsReceiving();
        }
        return 0L;
    }

    public long getTimeoutsSending(String transportType, String transportName) {
        TransportSender trpSender;
        TransportListener trpListener;
        if ("listener".equalsIgnoreCase(transportType) && (trpListener = ConfigHolder.getInstance().getTransportListener(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpListener).getTimeoutsSending();
        }
        if ("sender".equalsIgnoreCase(transportType) && (trpSender = ConfigHolder.getInstance().getTransportSender(transportName)) instanceof ManagementSupport) {
            return ((ManagementSupport)trpSender).getTimeoutsSending();
        }
        return 0L;
    }
}

