/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.springservices.ui.fileupload;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class SpringFileUploadExecutor
extends AbstractFileUploadExecutor {
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        Map formFieldsMap = this.getFormFieldsMap();
        String serviceHierarchy = (String)((ArrayList)formFieldsMap.get("serviceHierarchy")).get(0);
        request.getSession().setAttribute("service.hierarchy", (Object)serviceHierarchy);
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/carbon/spring/index.jsp"));
        }
        String[] uuids = new String[2];
        Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
        if (fileResourceMap == null) {
            fileResourceMap = new TreeBidiMap();
            this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
        }
        try {
            Iterator i$ = fileItemsMap.keySet().iterator();
            while (i$.hasNext()) {
                File uploadedFile;
                File servicesDir;
                String serviceUploadDir;
                String uuid;
                String o;
                String fieldName = o = (String)i$.next();
                FileItemData fileItemData = (FileItemData)((ArrayList)fileItemsMap.get(fieldName)).get(0);
                String fileName = this.getFileName(fileItemData.getFileItem().getName());
                if (fieldName.trim().equals("springBeans")) {
                    uuid = this.generateUUID();
                    serviceUploadDir = this.getWorkingDir() + File.separator + "spring" + File.separator + uuid + File.separator;
                    if (fileName.endsWith(".jar")) {
                        servicesDir = new File(serviceUploadDir);
                        if (!servicesDir.mkdirs()) {
                            log.error((Object)"Error while creating directories");
                        }
                        uploadedFile = new File(servicesDir, fileName);
                        uuids[0] = uuid;
                        fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                        fileItemData.getFileItem().write(uploadedFile);
                    }
                }
                if (!fieldName.trim().equals("springContext")) continue;
                uuid = this.generateUUID();
                serviceUploadDir = this.getWorkingDir() + File.separator + "spring" + File.separator + uuid + File.separator;
                servicesDir = new File(serviceUploadDir);
                if (!servicesDir.mkdirs()) {
                    log.error((Object)"Error while creating directories");
                }
                uploadedFile = new File(servicesDir, fileName);
                uuids[1] = uuid;
                fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                fileItemData.getFileItem().write(uploadedFile);
            }
            response.setContentType("text/html; charset=utf-8");
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/spring/showbeans.jsp?springBeansUUID=" + uuids[0] + "&springContextUUID=" + uuids[1]);
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/spring/index.jsp"));
            return false;
        }
    }
}

