/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mashup.request.processors.source;

import java.io.File;
import java.io.OutputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.mashup.utils.MashupUtils;

public class SourceRequestProcessor
implements HttpGetRequestProcessor {
    private static Log log = LogFactory.getLog(SourceRequestProcessor.class);

    public void process(CarbonHttpRequest request, CarbonHttpResponse response, ConfigurationContext configurationContext) throws Exception {
        String requestURI = request.getRequestURI();
        String contextPath = configurationContext.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        AxisConfiguration configuration = configurationContext.getAxisConfiguration();
        AxisService axisService = configuration.getServiceForActivation(serviceName);
        if (axisService == null) {
            axisService = TenantAxisUtils.getAxisService((String)serviceName, (ConfigurationContext)configurationContext);
        }
        OutputStream outputStream = response.getOutputStream();
        if (axisService != null) {
            if (axisService.isActive()) {
                String serviceType = (String)axisService.getParameterValue("serviceType");
                if ("js_service".equals(serviceType)) {
                    String contentTypeParameter = request.getParameter("content-type");
                    String contentType = "application/javascript";
                    if (contentTypeParameter != null && !"".equals(contentTypeParameter.trim())) {
                        contentType = contentTypeParameter;
                    }
                    response.addHeader("Content-Type", contentType + "; charset=utf-8");
                    String serviceJSFile = (String)axisService.getParameterValue("ServiceJS");
                    if (serviceJSFile != null) {
                        File file = new File(serviceJSFile);
                        MashupUtils.writeFile((CarbonHttpResponse)response, (File)file);
                    } else {
                        response.setStatus(404);
                        response.addHeader("Content-Type", "text/html");
                        outputStream.write("<h4>Source is not available for this service.".getBytes());
                        outputStream.flush();
                    }
                } else if ("data_service".equals(serviceType)) {
                    String contentTypeParameter = request.getParameter("content-type");
                    String contentType = "text/plain";
                    if (contentTypeParameter != null && !"".equals(contentTypeParameter.trim())) {
                        contentType = contentTypeParameter;
                    }
                    response.addHeader("Content-Type", contentType + "; charset=utf-8");
                    Parameter implInfoParam = axisService.getParameter("data_service");
                    if (implInfoParam != null && implInfoParam.getValue() instanceof String) {
                        String filePath = (String)implInfoParam.getValue();
                        File file = new File(filePath);
                        if (file.exists()) {
                            MashupUtils.writeFile((CarbonHttpResponse)response, (File)file);
                        } else {
                            response.setStatus(404);
                            response.addHeader("Content-Type", "text/html");
                            outputStream.write("<h4>Cannot find source file for Data Service".getBytes());
                            outputStream.flush();
                        }
                    } else {
                        response.setStatus(404);
                        response.addHeader("Content-Type", "text/html");
                        outputStream.write("<h4>Source is not available for this service.".getBytes());
                        outputStream.flush();
                    }
                } else {
                    response.setStatus(404);
                    response.addHeader("Content-Type", "text/html");
                    outputStream.write("<h4>Source is not available for this service. The source view is avalable only for JavaScript services".getBytes());
                    outputStream.flush();
                }
            } else {
                response.setStatus(404);
                response.addHeader("Content-Type", "text/html");
                outputStream.write("<h4>Source is not available for this service. This service is not active".getBytes());
                outputStream.flush();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot find the service" + serviceName + ". Axis Service is null."));
            }
            response.setStatus(404);
            response.addHeader("Content-Type", "text/html");
            outputStream.write("<h4>Service cannot be found. Cannot display <em>Source</em>.</h4>".getBytes());
            outputStream.flush();
        }
    }
}

