/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.service;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.tracer.module.MemoryBasedTracePersister;
import org.wso2.carbon.tracer.module.TracePersister;
import org.wso2.carbon.tracer.service.MessageInfo;
import org.wso2.carbon.tracer.service.MessagePayload;
import org.wso2.carbon.tracer.service.TracerServiceInfo;

public class TracerAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(TracerAdmin.class);

    public TracerServiceInfo getMessages(int numberOfMessages, String filter) throws AxisFault {
        ConfigurationContext configContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        CircularBuffer msgSeqBuff = this.getMessageSequenceBuffer();
        TracerServiceInfo tracerServiceInfo = new TracerServiceInfo();
        AxisModule axisModule = axisConfiguration.getModule("wso2tracer");
        if (axisModule == null) {
            throw new AxisFault("wso2tracer module is not available");
        }
        TracePersister tracePersister = this.getTracePersister();
        tracerServiceInfo.setTracePersister(tracePersister.getClass().getName());
        if (tracePersister.isTracingEnabled()) {
            if (!axisConfiguration.isEngaged(axisModule)) {
                axisConfiguration.engageModule(axisModule);
            }
            tracerServiceInfo.setFlag("ON");
        } else {
            if (axisConfiguration.isEngaged(axisModule)) {
                axisConfiguration.disengageModule(axisModule);
            }
            tracerServiceInfo.setFlag("OFF");
        }
        if (msgSeqBuff == null) {
            tracerServiceInfo.setEmpty(true);
            return tracerServiceInfo;
        }
        Object[] messageObjs = msgSeqBuff.getObjects(numberOfMessages);
        if (messageObjs.length == 0) {
            tracerServiceInfo.setEmpty(true);
            return tracerServiceInfo;
        }
        ArrayList<MessageInfo> msgInfoList = new ArrayList<MessageInfo>();
        boolean filterProvided = filter != null && (filter = filter.trim()).length() != 0;
        tracerServiceInfo.setFilter(filterProvided);
        for (Object messageObj : messageObjs) {
            MessageInfo mi = (MessageInfo)messageObj;
            if (filterProvided) {
                String resp;
                MessagePayload miPayload = this.getMessage(mi.getServiceId(), mi.getOperationName(), mi.getMessageSequence());
                String req = miPayload.getRequest();
                if (req == null) {
                    req = "";
                }
                if ((resp = miPayload.getResponse()) == null) {
                    resp = "";
                }
                if (req.toUpperCase().indexOf(filter.toUpperCase()) <= -1 && resp.toUpperCase().indexOf(filter.toUpperCase()) <= -1) continue;
                msgInfoList.add(mi);
                continue;
            }
            msgInfoList.add(mi);
        }
        if (filterProvided) {
            tracerServiceInfo.setFilterString(filter);
            if (msgInfoList.size() == 0) {
                tracerServiceInfo.setEmpty(true);
                return tracerServiceInfo;
            }
        }
        Collections.reverse(msgInfoList);
        MessageInfo lastMessageInfo = (MessageInfo)msgInfoList.get(0);
        tracerServiceInfo.setMessageInfo(msgInfoList.toArray(new MessageInfo[msgInfoList.size()]));
        MessagePayload lastMsg = this.getMessage(lastMessageInfo.getServiceId(), lastMessageInfo.getOperationName(), lastMessageInfo.getMessageSequence());
        tracerServiceInfo.setLastMessage(lastMsg);
        tracerServiceInfo.setEmpty(false);
        return tracerServiceInfo;
    }

    public TracerServiceInfo setMonitoring(String flag) throws AxisFault {
        if (!flag.equalsIgnoreCase("ON") && !flag.equalsIgnoreCase("OFF")) {
            throw new RuntimeException("IllegalArgument for monitoring status :" + flag);
        }
        TracerServiceInfo tracerServiceInfo = new TracerServiceInfo();
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        AxisModule axisModule = axisConfiguration.getModule("wso2tracer");
        if (axisModule == null) {
            throw new RuntimeException(TracerAdmin.class.getName() + " " + "wso2tracer" + " is not available");
        }
        if (flag.equalsIgnoreCase("ON")) {
            if (!axisConfiguration.isEngaged(axisModule.getName())) {
                try {
                    axisConfiguration.engageModule(axisModule);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)axisFault);
                    throw new RuntimeException(axisFault);
                }
            }
        } else if (flag.equalsIgnoreCase("OFF") && axisConfiguration.isEngaged(axisModule.getName())) {
            axisConfiguration.disengageModule(axisModule);
            configurationContext.removeProperty("wso2tracer.msg.seq.buff");
        }
        TracePersister tracePersister = this.getTracePersister();
        tracePersister.saveTraceStatus(flag);
        tracerServiceInfo.setEmpty(true);
        tracerServiceInfo.setFlag(flag);
        tracerServiceInfo.setTracePersister(tracePersister.getClass().getName());
        return tracerServiceInfo;
    }

    public MessagePayload getMessage(String serviceId, String operationName, long messageSequence) throws AxisFault {
        TracePersister tracePersisterImpl = this.getTracePersister();
        MessagePayload messagePayload = new MessagePayload();
        if (tracePersisterImpl != null) {
            String[] respArray = tracePersisterImpl.getMessages(serviceId, operationName, messageSequence, MessageContext.getCurrentMessageContext());
            if (respArray[0] != null) {
                messagePayload.setRequest(respArray[0]);
            }
            if (respArray[1] != null) {
                messagePayload.setResponse(respArray[1]);
            }
        } else {
            String message = "Tracer service encountered an error ";
            log.error((Object)message);
            throw new RuntimeException(message);
        }
        return messagePayload;
    }

    private TracePersister getTracePersister() throws AxisFault {
        Parameter tracePersisterParam = this.getAxisConfig().getParameter("wso2tracer.trace.persister.impl");
        return this.getTracePersister(tracePersisterParam);
    }

    public void clearAllSoapMessages() {
        CircularBuffer msgSeqBuff = this.getMessageSequenceBuffer();
        if (msgSeqBuff != null) {
            msgSeqBuff.clear();
        }
    }

    private CircularBuffer getMessageSequenceBuffer() {
        return (CircularBuffer)this.getConfigContext().getProperty("wso2tracer.msg.seq.buff");
    }

    private TracePersister getTracePersister(Parameter tracePersisterParam) throws AxisFault {
        TracePersister tracePersister = null;
        if (tracePersisterParam != null) {
            Object tracePersisterImplObj = tracePersisterParam.getValue();
            if (tracePersisterImplObj instanceof TracePersister) {
                tracePersister = (TracePersister)tracePersisterImplObj;
            } else if (tracePersisterImplObj instanceof String) {
                try {
                    tracePersister = (TracePersister)Loader.loadClass((String)((String)tracePersisterImplObj).trim()).newInstance();
                }
                catch (Exception e) {
                    String message = "Cannot instatiate TracePersister ";
                    log.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
        } else {
            return new MemoryBasedTracePersister();
        }
        return tracePersister;
    }
}

