/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.module.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.Handler;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.tracer.module.TraceFilter;
import org.wso2.carbon.tracer.module.handler.AbstractTracingHandler;

public class TracingMessageOutObservationHandler
extends AbstractTracingHandler {
    public Handler.InvocationResponse invoke(MessageContext outMsgCtx) throws AxisFault {
        AxisService axisService = outMsgCtx.getAxisService();
        if (axisService != null && axisService.isClientSide()) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (axisService != null && axisService.getParent() != null && SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup())) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (axisService == null) {
            MessageContext inMsgCtx = (MessageContext)outMsgCtx.getProperty("axis2.inMsgContext");
            String serviceName = "unknownService";
            String operationName = "unknowOperation";
            long msgSeq = this.storeMessage(serviceName, operationName, inMsgCtx, -1L);
            this.appendMessage(outMsgCtx.getConfigurationContext(), serviceName, operationName, msgSeq);
            this.storeMessage(serviceName, operationName, outMsgCtx, msgSeq);
            return Handler.InvocationResponse.CONTINUE;
        }
        ConfigurationContext configCtx = outMsgCtx.getConfigurationContext();
        TraceFilter traceFilter = (TraceFilter)configCtx.getAxisConfiguration().getParameter("wso2tracer.trace.filter.impl").getValue();
        if (traceFilter.isFilteredOut(outMsgCtx)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (outMsgCtx.getAxisOperation() != null && outMsgCtx.getAxisOperation().getName() != null) {
            String operationName = outMsgCtx.getAxisOperation().getName().getLocalPart();
            String serviceName = axisService.getName();
            this.storeMessage(serviceName, operationName, outMsgCtx, -1L);
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

