/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.module.handler;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.Handler;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.tracer.module.TraceFilter;
import org.wso2.carbon.tracer.module.TracePersister;
import org.wso2.carbon.tracer.module.handler.AbstractTracingHandler;

public class TracingInPostDispatchHandler
extends AbstractTracingHandler {
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        AxisService axisService = msgContext.getAxisService();
        if (axisService == null || axisService.isClientSide()) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (axisService.getParent() != null && SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getAxisServiceGroup())) {
            return Handler.InvocationResponse.CONTINUE;
        }
        ConfigurationContext configCtx = msgContext.getConfigurationContext();
        TraceFilter traceFilter = (TraceFilter)configCtx.getAxisConfiguration().getParameter("wso2tracer.trace.filter.impl").getValue();
        if (traceFilter.isFilteredOut(msgContext)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgContext.getAxisOperation() != null && msgContext.getAxisOperation().getName() != null) {
            String operationName = msgContext.getAxisOperation().getName().getLocalPart();
            String serviceName = axisService.getName();
            this.appendMessage(msgContext.getConfigurationContext(), serviceName, operationName, this.storeMessage(serviceName, operationName, msgContext));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected long storeMessage(String serviceName, String operationName, MessageContext msgCtxt) {
        TracePersister tracePersister = (TracePersister)msgCtxt.getConfigurationContext().getAxisConfiguration().getParameter("wso2tracer.trace.persister.impl").getValue();
        return tracePersister.saveMessage(serviceName, operationName, msgCtxt.getFLOW(), msgCtxt, (OMElement)msgCtxt.getProperty("wso2tracer.temp.envelope"), -1L);
    }
}

