/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.module.handler;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.handlers.AbstractHandler;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.tracer.module.TracePersister;
import org.wso2.carbon.tracer.service.MessageInfo;

public abstract class AbstractTracingHandler
extends AbstractHandler {
    protected void appendMessage(ConfigurationContext configCtx, String serviceName, String operationName, Long msgSeq) {
        CircularBuffer buffer = (CircularBuffer)configCtx.getProperty("wso2tracer.msg.seq.buff");
        if (buffer == null) {
            buffer = new CircularBuffer(250);
            configCtx.setProperty("wso2tracer.msg.seq.buff", (Object)buffer);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageSequence(msgSeq);
        messageInfo.setOperationName(operationName);
        messageInfo.setServiceId(serviceName);
        messageInfo.setTimestamp(cal);
        buffer.append((Object)messageInfo);
    }

    protected long storeMessage(String serviceName, String operationName, MessageContext msgCtxt, long msgSequenceNumber) {
        TracePersister tracePersister = (TracePersister)msgCtxt.getConfigurationContext().getAxisConfiguration().getParameter("wso2tracer.trace.persister.impl").getValue();
        return tracePersister.saveMessage(serviceName, operationName, msgCtxt.getFLOW(), msgCtxt, msgCtxt.getEnvelope().cloneOMElement(), msgSequenceNumber);
    }
}

