/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.module;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.Loader;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.tracer.module.DefaultTraceFilter;
import org.wso2.carbon.tracer.module.MemoryBasedTracePersister;
import org.wso2.carbon.tracer.module.TraceFilter;
import org.wso2.carbon.tracer.module.TracePersister;

public class TracerModule
implements Module {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConfigurationContext configContext, AxisModule axisModule) throws AxisFault {
        Object traceFilterImpl;
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        Parameter traceFilterImplParam = axisConfig.getParameter("wso2tracer.trace.filter.impl");
        if (traceFilterImplParam != null) {
            TraceFilter traceFilter;
            traceFilterImpl = ((String)traceFilterImplParam.getValue()).trim();
            try {
                traceFilter = (TraceFilter)Loader.loadClass((ClassLoader)axisModule.getModuleClassLoader(), (String)traceFilterImpl).newInstance();
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            traceFilterImplParam.setValue((Object)traceFilter);
            axisModule.addParameter(traceFilterImplParam);
        } else {
            traceFilterImpl = axisConfig;
            synchronized (traceFilterImpl) {
                axisConfig.addParameter(new Parameter("wso2tracer.trace.filter.impl", (Object)new DefaultTraceFilter()));
            }
        }
        Parameter tracePersisterImplParam = axisConfig.getParameter("wso2tracer.trace.persister.impl");
        if (tracePersisterImplParam != null) {
            TracePersister tracePersister;
            String tracePersisterImpl = ((String)tracePersisterImplParam.getValue()).trim();
            try {
                tracePersister = (TracePersister)Loader.loadClass((ClassLoader)axisModule.getModuleClassLoader(), (String)tracePersisterImpl).newInstance();
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            tracePersisterImplParam.setValue((Object)tracePersister);
            axisModule.addParameter(tracePersisterImplParam);
        } else {
            AxisConfiguration axisConfiguration = axisConfig;
            synchronized (axisConfiguration) {
                axisConfig.addParameter(new Parameter("wso2tracer.trace.persister.impl", (Object)new MemoryBasedTracePersister()));
            }
        }
        CircularBuffer msgSeqBuff = new CircularBuffer(250);
        configContext.setProperty("wso2tracer.msg.seq.buff", (Object)msgSeqBuff);
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }
}

