/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.module;

import java.util.HashMap;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.wso2.carbon.logging.appenders.CircularBuffer;
import org.wso2.carbon.tracer.TracerUtils;
import org.wso2.carbon.tracer.module.TraceMessage;
import org.wso2.carbon.tracer.module.TracePersister;

public class MemoryBasedTracePersister
implements TracePersister {
    private static final String TRACING_MAP = "local_wso2tracer.map";
    private static final String REQUEST_NUMBER = "local_wso2tracer.request.number";
    private CircularBuffer msgBuffer = new CircularBuffer(250);
    private String tracingStatus;

    @Override
    public synchronized long saveMessage(String serviceName, String operationName, int messageFlow, MessageContext msgContext, OMElement env, long msgSequenceNumber) {
        long msgSequence = this.getMessageSequence(serviceName, operationName, msgContext, msgSequenceNumber);
        MessagePair tmp = new MessagePair(serviceName, operationName, msgSequence);
        Object[] objects = this.msgBuffer.getObjects(250);
        boolean msgPairFound = false;
        for (Object object : objects) {
            MessagePair msgPair = (MessagePair)object;
            if (!msgPair.equals(tmp)) continue;
            msgPairFound = true;
            TraceMessage msg = new TraceMessage(serviceName, operationName, messageFlow, msgSequence, env);
            if (messageFlow == 1 || messageFlow == 3) {
                msgPair.setInMessage(msg);
                continue;
            }
            if (messageFlow != 2 && messageFlow != 4) continue;
            msgPair.setOutMessage(msg);
        }
        if (!msgPairFound) {
            TraceMessage msg = new TraceMessage(serviceName, operationName, messageFlow, msgSequence, env);
            if (messageFlow == 1 || messageFlow == 3) {
                tmp.setInMessage(msg);
            } else if (messageFlow == 2 || messageFlow == 4) {
                tmp.setOutMessage(msg);
            }
            this.msgBuffer.append((Object)tmp);
        }
        return msgSequence;
    }

    @Override
    public void saveTraceStatus(String onOff) {
        this.tracingStatus = onOff;
    }

    @Override
    public boolean isTracingEnabled() {
        return this.tracingStatus != null && this.tracingStatus.equalsIgnoreCase("ON");
    }

    @Override
    public synchronized String[] getMessages(String serviceName, String operationName, long messageSequence, MessageContext msgContext) {
        String[] responses = new String[2];
        Object[] objects = this.msgBuffer.getObjects(250);
        MessagePair tmp = new MessagePair(serviceName, operationName, messageSequence);
        for (Object object : objects) {
            MessagePair msgPair = (MessagePair)object;
            if (!msgPair.equals(tmp)) continue;
            TraceMessage inMessage = msgPair.getInMessage();
            responses[0] = inMessage != null && inMessage.getSoapEnvelope() != null ? TracerUtils.getPrettyString(inMessage.getSoapEnvelope(), msgContext) : "No request found";
            TraceMessage outMessage = msgPair.getOutMessage();
            responses[1] = outMessage != null && outMessage.getSoapEnvelope() != null ? TracerUtils.getPrettyString(outMessage.getSoapEnvelope(), msgContext) : "No response found";
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMessageSequence(String serviceName, String operationName, MessageContext msgContext, long msgSequenceNumber) {
        long msgSequence = 1L;
        String string = serviceName + operationName;
        synchronized (string) {
            OperationContext operationContext = msgContext.getOperationContext();
            Object requestNumber = null;
            if (operationContext != null) {
                requestNumber = operationContext.getProperty(REQUEST_NUMBER);
            } else if (msgSequenceNumber != -1L) {
                requestNumber = msgSequenceNumber;
            }
            if (requestNumber != null && requestNumber instanceof Long) {
                msgSequence = ((Long)requestNumber).intValue();
            } else {
                String key;
                Object counterInt;
                HashMap<String, Long> monitoringHandlerMap = (HashMap<String, Long>)msgContext.getConfigurationContext().getProperty(TRACING_MAP);
                if (monitoringHandlerMap == null) {
                    monitoringHandlerMap = new HashMap<String, Long>();
                    msgContext.getConfigurationContext().setProperty(TRACING_MAP, monitoringHandlerMap);
                }
                if ((counterInt = monitoringHandlerMap.get(key = serviceName + "." + operationName)) == null) {
                    msgSequence = 0L;
                } else if (counterInt instanceof Long) {
                    msgSequence = ((Long)counterInt).intValue() + 1;
                }
                monitoringHandlerMap.put(key, new Long(msgSequence));
                if (operationContext != null) {
                    operationContext.setProperty(REQUEST_NUMBER, (Object)new Long(msgSequence));
                }
            }
        }
        return msgSequence;
    }

    private static class MessagePair {
        private String serviceName;
        private String operationName;
        private long sequenceId;
        private TraceMessage inMessage;
        private TraceMessage outMessage;

        private MessagePair(String serviceName, String operationName, long sequenceId) {
            this.serviceName = serviceName;
            this.operationName = operationName;
            this.sequenceId = sequenceId;
        }

        public void setInMessage(TraceMessage request) {
            this.inMessage = request;
        }

        public void setOutMessage(TraceMessage response) {
            this.outMessage = response;
        }

        public TraceMessage getInMessage() {
            return this.inMessage;
        }

        public TraceMessage getOutMessage() {
            return this.outMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessagePair that = (MessagePair)o;
            return this.sequenceId == that.sequenceId && this.operationName.equals(that.operationName) && this.serviceName.equals(that.serviceName);
        }

        public int hashCode() {
            int result = this.serviceName.hashCode();
            result = 31 * result + this.operationName.hashCode();
            result = 31 * result + (int)(this.sequenceId ^ this.sequenceId >>> 32);
            return result;
        }
    }
}

