/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.stream.AbstractStaxXmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public class StaxEventXmlReader
extends AbstractStaxXmlReader {
    private final XMLEventReader reader;

    public StaxEventXmlReader(XMLEventReader reader) {
        try {
            XMLEvent event = reader.peek();
            if (event == null || !event.isStartDocument() && !event.isStartElement()) {
                throw new IllegalStateException("XMLEventReader not at start of document or element");
            }
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Could not read first element: " + ex.getMessage());
        }
        this.reader = reader;
    }

    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        while (this.reader.hasNext() && elementDepth >= 0) {
            XMLEvent event = this.reader.nextEvent();
            if (!(event.isStartDocument() || event.isEndDocument() || documentStarted)) {
                this.handleStartDocument();
                documentStarted = true;
            }
            switch (event.getEventType()) {
                case 1: {
                    ++elementDepth;
                    this.handleStartElement(event.asStartElement());
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement(event.asEndElement());
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction((ProcessingInstruction)event);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters(event.asCharacters());
                    break;
                }
                case 7: {
                    this.setLocator(event.getLocation());
                    this.handleStartDocument();
                    documentStarted = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                    break;
                }
                case 14: {
                    this.handleNotationDeclaration((NotationDeclaration)event);
                    break;
                }
                case 15: {
                    this.handleEntityDeclaration((EntityDeclaration)event);
                    break;
                }
                case 5: {
                    this.handleComment((Comment)event);
                    break;
                }
                case 11: {
                    this.handleDtd((DTD)event);
                    break;
                }
                case 9: {
                    this.handleEntityReference((EntityReference)event);
                }
            }
        }
        if (!documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleStartElement(StartElement startElement) throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = startElement.getName();
            if (this.hasNamespacesFeature()) {
                Iterator<Namespace> i = startElement.getNamespaces();
                while (i.hasNext()) {
                    Namespace namespace = i.next();
                    this.getContentHandler().startPrefixMapping(namespace.getPrefix(), namespace.getNamespaceURI());
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), QNameUtils.toQualifiedName(qName), this.getAttributes(startElement));
            } else {
                this.getContentHandler().startElement("", "", QNameUtils.toQualifiedName(qName), this.getAttributes(startElement));
            }
        }
    }

    private void handleCharacters(Characters characters) throws SAXException {
        char[] data = characters.getData().toCharArray();
        if (this.getContentHandler() != null && characters.isIgnorableWhiteSpace()) {
            this.getContentHandler().ignorableWhitespace(data, 0, data.length);
            return;
        }
        if (characters.isCData() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(data, 0, data.length);
        }
        if (characters.isCData() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleEndElement(EndElement endElement) throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = endElement.getName();
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), QNameUtils.toQualifiedName(qName));
                Iterator<Namespace> i = endElement.getNamespaces();
                while (i.hasNext()) {
                    Namespace namespace = i.next();
                    this.getContentHandler().endPrefixMapping(namespace.getPrefix());
                }
            } else {
                this.getContentHandler().endElement("", "", QNameUtils.toQualifiedName(qName));
            }
        }
    }

    private void handleNotationDeclaration(NotationDeclaration declaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().notationDecl(declaration.getName(), declaration.getPublicId(), declaration.getSystemId());
        }
    }

    private void handleEntityDeclaration(EntityDeclaration entityDeclaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
        }
    }

    private void handleProcessingInstruction(ProcessingInstruction pi) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(pi.getTarget(), pi.getData());
        }
    }

    private void handleStartDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
        }
    }

    private void handleComment(Comment comment) throws SAXException {
        if (this.getLexicalHandler() != null) {
            char[] ch = comment.getText().toCharArray();
            this.getLexicalHandler().comment(ch, 0, ch.length);
        }
    }

    private void handleDtd(DTD dtd) throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = dtd.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference(EntityReference reference) throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(reference.getName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(reference.getName());
        }
    }

    private Attributes getAttributes(StartElement event) {
        AttributesImpl attributes = new AttributesImpl();
        Iterator<Attribute> i = event.getAttributes();
        while (i.hasNext()) {
            String type;
            Attribute attribute = i.next();
            QName qName = attribute.getName();
            String namespace = qName.getNamespaceURI();
            if (namespace == null || !this.hasNamespacesFeature()) {
                namespace = "";
            }
            if ((type = attribute.getDTDType()) == null) {
                type = "CDATA";
            }
            attributes.addAttribute(namespace, qName.getLocalPart(), QNameUtils.toQualifiedName(qName), type, attribute.getValue());
        }
        if (this.hasNamespacePrefixesFeature()) {
            i = event.getNamespaces();
            while (i.hasNext()) {
                Namespace namespace = (Namespace)i.next();
                String prefix = namespace.getPrefix();
                String namespaceUri = namespace.getNamespaceURI();
                String qName = StringUtils.hasLength(prefix) ? "xmlns:" + prefix : "xmlns";
                attributes.addAttribute("", "", qName, "CDATA", namespaceUri);
            }
        }
        return attributes;
    }
}

