/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixToNamespaceUri = new LinkedHashMap<String, String>();
    private Map<String, Set<String>> namespaceUriToPrefixes = new LinkedHashMap<String, Set<String>>();

    @Override
    public String getNamespaceURI(String prefix) {
        Assert.notNull(prefix, "prefix is null");
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefixToNamespaceUri.containsKey(prefix)) {
            return this.prefixToNamespaceUri.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceUri) {
        Iterator<String> iterator = this.getPrefixes(namespaceUri);
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceUri) {
        Set<String> prefixes = this.getPrefixesInternal(namespaceUri);
        prefixes = Collections.unmodifiableSet(prefixes);
        return prefixes.iterator();
    }

    public void setBindings(Map<String, String> bindings) {
        for (Map.Entry<String, String> entry : bindings.entrySet()) {
            this.bindNamespaceUri(entry.getKey(), entry.getValue());
        }
    }

    public void bindDefaultNamespaceUri(String namespaceUri) {
        this.bindNamespaceUri("", namespaceUri);
    }

    public void bindNamespaceUri(String prefix, String namespaceUri) {
        Assert.notNull(prefix, "No prefix given");
        Assert.notNull(namespaceUri, "No namespaceUri given");
        if ("xml".equals(prefix)) {
            Assert.isTrue("http://www.w3.org/XML/1998/namespace".equals(namespaceUri), "Prefix \"" + prefix + "\" bound to namespace \"" + namespaceUri + "\" (should be \"" + "http://www.w3.org/XML/1998/namespace" + "\")");
        } else if ("xmlns".equals(prefix)) {
            Assert.isTrue("http://www.w3.org/2000/xmlns/".equals(namespaceUri), "Prefix \"" + prefix + "\" bound to namespace \"" + namespaceUri + "\" (should be \"" + "http://www.w3.org/2000/xmlns/" + "\")");
        } else {
            this.prefixToNamespaceUri.put(prefix, namespaceUri);
            this.getPrefixesInternal(namespaceUri).add(prefix);
        }
    }

    public void clear() {
        this.prefixToNamespaceUri.clear();
        this.namespaceUriToPrefixes.clear();
    }

    public Iterator<String> getBoundPrefixes() {
        Set<String> prefixes = new HashSet<String>(this.prefixToNamespaceUri.keySet());
        prefixes.remove("");
        prefixes = Collections.unmodifiableSet(prefixes);
        return prefixes.iterator();
    }

    private Set<String> getPrefixesInternal(String namespaceUri) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            return Collections.singleton("xml");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            return Collections.singleton("xmlns");
        }
        Set<String> set = this.namespaceUriToPrefixes.get(namespaceUri);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.namespaceUriToPrefixes.put(namespaceUri, set);
        }
        return set;
    }

    public void removeBinding(String prefix) {
        String namespaceUri = this.prefixToNamespaceUri.get(prefix);
        Set<String> prefixes = this.getPrefixesInternal(namespaceUri);
        prefixes.remove(prefix);
    }

    public boolean hasBinding(String prefix) {
        return this.prefixToNamespaceUri.containsKey(prefix);
    }
}

