/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttle.service;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.throttle.InternalData;
import org.wso2.carbon.throttle.ThrottleComponentException;
import org.wso2.carbon.throttle.ThrottlePolicy;
import org.wso2.throttle.ThrottleConstants;

public class ThrottleConfigAdminService
extends AbstractAdmin {
    private ServiceGroupFilePersistenceManager sfpm;
    private ModuleFilePersistenceManager mfpm;
    private PersistenceFactory pf;
    private Registry registry;
    protected AxisConfiguration axisConfig = null;
    private Policy policyToUpdate = null;
    private static final String ADMIN_SERICE_PARAM_NAME = "adminService";
    private static final String HIDDEN_SERVICE_PARAM_NAME = "hiddenService";
    private static final String GLOBALLY_ENGAGED_PARAM_NAME = "globallyEngaged";
    private static final String GLOBALLY_ENGAGED_CUSTOM = "globallyEngagedCustom";
    private static final Log log = LogFactory.getLog(ThrottleConfigAdminService.class);
    private String wSO2ServiceThrottlingPolicyId = "WSO2ServiceThrottlingPolicy";
    private String wSO2OperationThrottlingPolicyId = "WSO2OperationThrottlingPolicy";
    private String wSO2ModuleThrottlingPolicyId = "WSO2ModuleThrottlingPolicy";
    private String wSO2MediatorThrottlingPolicyId = "WSO2MediatorThrottlingPolicy";

    public ThrottleConfigAdminService() {
        try {
            this.axisConfig = this.getAxisConfig();
            this.pf = PersistenceFactory.getInstance((AxisConfiguration)this.axisConfig);
            this.sfpm = this.pf.getServiceGroupFilePM();
            this.mfpm = this.pf.getModuleFilePM();
            this.registry = this.getConfigSystemRegistry();
        }
        catch (Exception e) {
            log.error((Object)"Can't initialize ThrottleAdminService.", (Throwable)e);
        }
    }

    public void enableThrottling(String serviceName, ThrottlePolicy policy) throws AxisFault, ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaging throttling for the serviceName : " + serviceName));
        }
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
        AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        try {
            Policy builtPolicy;
            boolean registryTransactionStarted;
            boolean transactionStarted = this.sfpm.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.sfpm.beginTransaction(serviceGroupId);
            }
            if (!(registryTransactionStarted = Transaction.isStarted())) {
                this.registry.beginTransaction();
            }
            try {
                List associations = this.sfpm.getAll(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
                boolean associationExist = false;
                String version = module.getVersion().toString();
                if (module.getVersion() == null) {
                    version = "undefined";
                }
                for (Object node : associations) {
                    OMElement association = (OMElement)node;
                    if (!association.getAttributeValue(new QName("name")).equals(module.getName()) || !association.getAttributeValue(new QName("version")).equals(version)) continue;
                    associationExist = true;
                    break;
                }
                if (!associationExist) {
                    this.sfpm.put(serviceGroupId, PersistenceUtils.createModule((String)module.getName(), (String)version, (String)"engagedModules"), serviceXPath);
                }
            }
            catch (PersistenceException e) {
                log.error((Object)"Error occured in persisting throttling", (Throwable)e);
                throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
            }
            XmlPrimtiveAssertion assertion = this.getThrottlePolicy(axisService.getPolicySubject().getAttachedPolicyComponents());
            OMElement policyElement = this.buildPolicy(policy, assertion, "service");
            Policy policyToPersist = builtPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
            if (assertion == null) {
                axisService.getPolicySubject().attachPolicy(builtPolicy);
            } else {
                axisService.getPolicySubject().updatePolicy(this.policyToUpdate);
                policyToPersist = this.policyToUpdate;
            }
            try {
                if (isProxyService) {
                    String policyType = "3";
                    String registryServicePath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService);
                    this.pf.getServicePM().persistPolicyToRegistry(policyToPersist, policyType, registryServicePath);
                }
                OMFactory omFactory = OMAbstractFactory.getOMFactory();
                OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
                policyWrapperElement.addAttribute("policyType", "3", null);
                OMElement idElement = omFactory.createOMElement("policyUUID", null);
                idElement.setText("" + policyToPersist.getId());
                policyWrapperElement.addChild((OMNode)idElement);
                OMElement policyElementToPersist = PersistenceUtils.createPolicyElement((Policy)policyToPersist);
                policyWrapperElement.addChild((OMNode)policyElementToPersist);
                if (!this.sfpm.elementExists(serviceGroupId, serviceXPath + "/" + "policies")) {
                    this.sfpm.put(serviceGroupId, omFactory.createOMElement("policies", null), serviceXPath);
                } else {
                    String pathToPolicy = serviceXPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policyToPersist.getId());
                    if (this.sfpm.elementExists(serviceGroupId, pathToPolicy)) {
                        this.sfpm.delete(serviceGroupId, pathToPolicy);
                    }
                }
                this.sfpm.put(serviceGroupId, policyWrapperElement, serviceXPath + "/" + "policies");
                if (!this.sfpm.elementExists(serviceGroupId, serviceXPath + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policyToPersist.getId()))) {
                    this.sfpm.put(serviceGroupId, idElement.cloneOMElement(), serviceXPath);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while persisting", (Throwable)e);
                this.sfpm.rollbackTransaction(serviceGroupId);
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException re) {
                    log.error((Object)e.getMessage(), (Throwable)re);
                }
                throw new ThrottleComponentException("errorSavingPolicy");
            }
            if (!transactionStarted) {
                this.sfpm.commitTransaction(serviceGroupId);
            }
            if (!registryTransactionStarted) {
                this.registry.commitTransaction();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while saving the builtPolicy in registry", (Throwable)e);
            this.sfpm.rollbackTransaction(serviceGroupId);
            try {
                this.registry.rollbackTransaction();
            }
            catch (RegistryException re) {
                log.error((Object)e.getMessage(), (Throwable)re);
            }
            throw new ThrottleComponentException("errorSavingPolicy");
        }
        axisService.engageModule(module);
    }

    public void globallyEngageThrottling(ThrottlePolicy policy) throws AxisFault, ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Globally engaging throttling");
        }
        AxisModule module = this.axisConfig.getModule("wso2throttle");
        String globalPath = PersistenceUtils.getResourcePath((AxisModule)module);
        try {
            Policy builtPolicy;
            this.mfpm.beginTransaction(module.getName());
            try {
                if (this.mfpm.elementExists(module.getName(), globalPath)) {
                    OMElement element = (OMElement)this.mfpm.get(module.getName(), globalPath);
                    if (!Boolean.parseBoolean(element.getAttributeValue(new QName(GLOBALLY_ENGAGED_CUSTOM)))) {
                        element.addAttribute(GLOBALLY_ENGAGED_CUSTOM, Boolean.TRUE.toString(), null);
                        this.mfpm.setMetaFileModification(module.getName());
                    }
                } else {
                    OMFactory omFactory = OMAbstractFactory.getOMFactory();
                    OMElement moduleElement = omFactory.createOMElement("version", null);
                    if (module.getVersion() != null) {
                        moduleElement.addAttribute("id", module.getVersion().toString(), null);
                    } else {
                        moduleElement.addAttribute("id", "undefined", null);
                    }
                    moduleElement.addAttribute(GLOBALLY_ENGAGED_CUSTOM, Boolean.TRUE.toString(), null);
                    this.mfpm.put(module.getName(), moduleElement, "/");
                }
            }
            catch (PersistenceException e) {
                log.error((Object)"Error occurred in globally engaging throttling at registry", (Throwable)e);
                throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
            }
            XmlPrimtiveAssertion assertion = this.getThrottlePolicy(module.getPolicySubject().getAttachedPolicyComponents());
            OMElement policyElement = this.buildPolicy(policy, assertion, "global");
            Policy policyToPersist = builtPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
            if (assertion == null) {
                module.getPolicySubject().attachPolicy(builtPolicy);
            } else {
                module.getPolicySubject().updatePolicy(this.policyToUpdate);
                policyToPersist = this.policyToUpdate;
            }
            try {
                OMFactory omFactory = OMAbstractFactory.getOMFactory();
                OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
                policyWrapperElement.addAttribute("policyType", "2", null);
                OMElement idElement = omFactory.createOMElement("policyUUID", null);
                idElement.setText("" + policyToPersist.getId());
                policyWrapperElement.addChild((OMNode)idElement);
                policyWrapperElement.addAttribute("version", module.getVersion().toString(), null);
                OMElement policyElementToPersist = PersistenceUtils.createPolicyElement((Policy)policyToPersist);
                policyWrapperElement.addChild((OMNode)policyElementToPersist);
                if (!this.mfpm.elementExists(module.getName(), globalPath + "/" + "policies")) {
                    this.mfpm.put(module.getName(), omFactory.createOMElement("policies", null), globalPath);
                } else {
                    String pathToPolicy = globalPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policyToPersist.getId());
                    if (this.mfpm.elementExists(module.getName(), pathToPolicy)) {
                        this.mfpm.delete(module.getName(), pathToPolicy);
                    }
                }
                this.mfpm.put(module.getName(), policyWrapperElement, globalPath + "/" + "policies");
            }
            catch (Exception e) {
                log.error((Object)"Error occured while saving the builtPolicy in registry", (Throwable)e);
                throw new ThrottleComponentException("errorSavingPolicy");
            }
            this.mfpm.commitTransaction(module.getName());
            module.addParameter(new Parameter(GLOBALLY_ENGAGED_PARAM_NAME, (Object)Boolean.TRUE.toString()));
            try {
                for (AxisService service : this.axisConfig.getServices().values()) {
                    String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERICE_PARAM_NAME);
                    String hiddenParamValue = (String)service.getParent().getParameterValue(HIDDEN_SERVICE_PARAM_NAME);
                    if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim()) || hiddenParamValue != null && hiddenParamValue.length() != 0 && Boolean.parseBoolean(hiddenParamValue.trim())) continue;
                    this.enableThrottling(service.getName(), policy);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred in globally engaging throttlin at registry", (Throwable)e);
                this.mfpm.rollbackTransaction(module.getName());
                throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred in globally beginning/committing the transaction", (Throwable)e);
            this.mfpm.rollbackTransaction(module.getName());
            throw new ThrottleComponentException("errorSavingPolicy");
        }
    }

    public boolean engageThrottlingForOperation(ThrottlePolicy policy, String serviceName, String operationName) throws AxisFault, ThrottleComponentException {
        Policy builtPolicy;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Engaging throttling for the operation : " + operationName + ", in service :" + serviceName));
        }
        AxisService axisService = this.getAxisService(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
        AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
        if (axisService.isEngaged(module)) {
            return true;
        }
        AxisOperation operation = axisService.getOperation(new QName(operationName));
        if (operation == null) {
            log.error((Object)("No operation found from the name " + operationName + ", in service : " + serviceName));
            throw new ThrottleComponentException("noSuchOperation", new String[]{serviceName});
        }
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        String operationXPath = PersistenceUtils.getResourcePath((AxisOperation)operation);
        try {
            boolean isTransactionStarted = this.sfpm.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.sfpm.beginTransaction(serviceGroupId);
            }
            List associations = this.sfpm.getAll(serviceGroupId, operationXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
            boolean associationExist = false;
            String version = module.getVersion().toString();
            if (module.getVersion() == null) {
                version = "undefined";
            }
            for (Object node : associations) {
                OMElement association = (OMElement)node;
                if (!association.getAttributeValue(new QName("name")).equals(module.getName()) || !association.getAttributeValue(new QName("version")).equals(version)) continue;
                associationExist = true;
                break;
            }
            if (!associationExist) {
                this.sfpm.put(serviceGroupId, PersistenceUtils.createModule((String)module.getName(), (String)version, (String)"engagedModules"), operationXPath);
            }
            if (!isTransactionStarted) {
                this.sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)("Error occured in engaging throttling for operation : " + operationName), (Throwable)e);
            throw new ThrottleComponentException("errorEngagingModuleAtRegistry");
        }
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(operation.getPolicySubject().getAttachedPolicyComponents());
        OMElement policyElement = this.buildPolicy(policy, assertion, "operation");
        Policy policyToPersist = builtPolicy = PolicyEngine.getPolicy((OMElement)policyElement);
        if (assertion == null) {
            operation.getPolicySubject().attachPolicy(builtPolicy);
        } else {
            operation.getPolicySubject().updatePolicy(this.policyToUpdate);
            policyToPersist = this.policyToUpdate;
        }
        try {
            boolean registryTransactionStarted;
            boolean isTransactionStarted = this.sfpm.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.sfpm.beginTransaction(serviceGroupId);
            }
            if (!(registryTransactionStarted = Transaction.isStarted())) {
                this.registry.beginTransaction();
            }
            if (isProxyService) {
                String policyType = "4";
                String registryServicePath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService);
                this.pf.getServicePM().persistPolicyToRegistry(policyToPersist, policyType, registryServicePath);
            }
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
            policyWrapperElement.addAttribute("policyType", "4", null);
            OMElement idElement = omFactory.createOMElement("policyUUID", null);
            idElement.setText("" + policyToPersist.getId());
            policyWrapperElement.addChild((OMNode)idElement);
            OMElement policyElementToPersist = PersistenceUtils.createPolicyElement((Policy)policyToPersist);
            policyWrapperElement.addChild((OMNode)policyElementToPersist);
            if (!this.sfpm.elementExists(serviceGroupId, serviceXPath + "/" + "policies")) {
                this.sfpm.put(serviceGroupId, omFactory.createOMElement("policies", null), serviceXPath);
            } else {
                String pathToPolicy = serviceXPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policyToPersist.getId());
                if (this.sfpm.elementExists(serviceGroupId, pathToPolicy)) {
                    this.sfpm.delete(serviceGroupId, pathToPolicy);
                }
            }
            this.sfpm.put(serviceGroupId, policyWrapperElement, serviceXPath + "/" + "policies");
            if (!this.sfpm.elementExists(serviceGroupId, serviceXPath + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policyToPersist.getId()))) {
                this.sfpm.put(serviceGroupId, idElement.cloneOMElement(), operationXPath);
            }
            if (!isTransactionStarted) {
                this.sfpm.commitTransaction(serviceGroupId);
            }
            if (!registryTransactionStarted) {
                this.registry.commitTransaction();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while saving the builtPolicy in registry", (Throwable)e);
            this.sfpm.rollbackTransaction(serviceGroupId);
            throw new ThrottleComponentException("errorSavingPolicy");
        }
        operation.engageModule(module);
        return false;
    }

    public boolean disengageThrottlingForOperation(String serviceName, String operationName) throws ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disengaging throttling from the operation : " + operationName + ", in service : " + serviceName));
        }
        try {
            AxisService axisService = this.getAxisService(serviceName);
            String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
            boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
            String registryPolicyPath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService) + "/policies/";
            AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
            if (axisService.isEngaged(module)) {
                return true;
            }
            AxisOperation operation = axisService.getOperation(new QName(operationName));
            if (operation == null) {
                log.error((Object)("No operation found from the name " + operationName + ", in service : " + serviceName));
                throw new ThrottleComponentException("noSuchOperation", new String[]{serviceName});
            }
            String operationXPath = PersistenceUtils.getResourcePath((AxisOperation)operation);
            try {
                boolean isTransactionStarted = this.sfpm.isTransactionStarted(serviceGroupId);
                if (!isTransactionStarted) {
                    this.sfpm.beginTransaction(serviceGroupId);
                }
                this.sfpm.delete(serviceGroupId, operationXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)module.getName()) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
                if (!isTransactionStarted) {
                    this.sfpm.commitTransaction(serviceGroupId);
                }
                if (isProxyService) {
                    boolean registryTransactionStarted = Transaction.isStarted();
                    if (!registryTransactionStarted) {
                        this.registry.beginTransaction();
                    }
                    if (this.registry.resourceExists(registryPolicyPath + this.wSO2OperationThrottlingPolicyId)) {
                        this.registry.delete(registryPolicyPath + this.wSO2OperationThrottlingPolicyId);
                    } else {
                        log.warn((Object)("Could not delete the Operation Throttling policy because it does not exist at " + registryPolicyPath + this.wSO2OperationThrottlingPolicyId));
                    }
                    if (!registryTransactionStarted) {
                        this.registry.commitTransaction();
                    }
                }
                operation.disengageModule(module);
            }
            catch (PersistenceException e) {
                log.error((Object)"Error occured while removing assertion from file system", (Throwable)e);
                this.sfpm.rollbackTransaction(serviceGroupId);
                throw new ThrottleComponentException("errorDisablingAtRegistry");
            }
            catch (RegistryException e) {
                log.error((Object)("Error while deleting throttling policy from registry path : " + registryPolicyPath + this.wSO2OperationThrottlingPolicyId), (Throwable)e);
                this.sfpm.rollbackTransaction(serviceGroupId);
                throw new ThrottleComponentException("errorDisablingAtRegistry");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)e);
            throw new ThrottleComponentException("errorDisablingThrottling", e);
        }
        return false;
    }

    public void disableThrottling(String serviceName) throws ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disengaging throttling from the service : " + serviceName));
        }
        try {
            AxisService axisService = this.getAxisService(serviceName);
            String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
            String registryPolicyPath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService) + "/policies/";
            try {
                AxisModule module = axisService.getAxisConfiguration().getModule("wso2throttle");
                boolean isTransactionStarted = this.sfpm.isTransactionStarted(serviceGroupId);
                if (!isTransactionStarted) {
                    this.sfpm.beginTransaction(serviceGroupId);
                }
                this.sfpm.delete(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)module.getName()) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
                if (!isTransactionStarted) {
                    this.sfpm.commitTransaction(serviceGroupId);
                }
                if (isProxyService) {
                    boolean registryTransactionStarted = Transaction.isStarted();
                    if (!registryTransactionStarted) {
                        this.registry.beginTransaction();
                    }
                    if (this.registry.resourceExists(registryPolicyPath + this.wSO2ServiceThrottlingPolicyId)) {
                        this.registry.delete(registryPolicyPath + this.wSO2ServiceThrottlingPolicyId);
                    } else {
                        log.warn((Object)("Could not delete the Service Throttling policy because it does not exist at " + registryPolicyPath + this.wSO2ServiceThrottlingPolicyId));
                    }
                    if (!registryTransactionStarted) {
                        this.registry.commitTransaction();
                    }
                }
                axisService.disengageModule(module);
            }
            catch (PersistenceException e) {
                log.error((Object)"Error occured while removing assertion from registry", (Throwable)e);
                this.sfpm.rollbackTransaction(serviceGroupId);
                throw new ThrottleComponentException("errorDisablingAtRegistry");
            }
            catch (RegistryException e) {
                log.error((Object)("Error while deleting throttling policy from registry path : " + registryPolicyPath + this.wSO2ServiceThrottlingPolicyId), (Throwable)e);
                this.sfpm.rollbackTransaction(serviceGroupId);
                throw new ThrottleComponentException("errorDisablingAtRegistry");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error occured while disengaging module from AxisService", (Throwable)e);
            throw new ThrottleComponentException("errorDisablingThrottling", e);
        }
    }

    public void disengageGlobalThrottling() throws ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Disengaging globally engaged throttling");
        }
        AxisModule module = this.axisConfig.getModule("wso2throttle");
        try {
            Parameter param;
            OMElement element;
            boolean isTransactionStarted = this.mfpm.isTransactionStarted(module.getName());
            if (!isTransactionStarted) {
                this.mfpm.beginTransaction(module.getName());
            }
            String modulePath = PersistenceUtils.getResourcePath((AxisModule)module);
            if (this.mfpm.elementExists(module.getName(), modulePath) && !Boolean.parseBoolean((element = (OMElement)this.mfpm.get(module.getName(), modulePath)).getAttributeValue(new QName(GLOBALLY_ENGAGED_CUSTOM)))) {
                element.addAttribute(GLOBALLY_ENGAGED_CUSTOM, Boolean.FALSE.toString(), null);
                this.mfpm.setMetaFileModification(module.getName());
            }
            if (!isTransactionStarted) {
                this.mfpm.commitTransaction(module.getName());
            }
            if ((param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME)) != null) {
                module.removeParameter(module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME));
            }
            for (AxisService service : this.axisConfig.getServices().values()) {
                String adminParamValue = (String)service.getParent().getParameterValue(ADMIN_SERICE_PARAM_NAME);
                String hiddenParamValue = (String)service.getParent().getParameterValue(HIDDEN_SERVICE_PARAM_NAME);
                if (adminParamValue != null && adminParamValue.length() != 0 && Boolean.parseBoolean(adminParamValue.trim()) || hiddenParamValue != null && hiddenParamValue.length() != 0 && Boolean.parseBoolean(hiddenParamValue.trim())) continue;
                this.disableThrottling(service.getName());
            }
        }
        catch (PersistenceException e) {
            log.error((Object)"Error occurred while removing global throttle from file system", (Throwable)e);
            this.mfpm.rollbackTransaction(module.getName());
            throw new ThrottleComponentException("errorDisablingAtRegistry");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error occurred while disengaging module from AxisService", (Throwable)axisFault);
            this.mfpm.rollbackTransaction(module.getName());
            throw new ThrottleComponentException("errorDisablingThrottling", axisFault);
        }
    }

    public ThrottlePolicy getPolicyConfigs(String serviceName) throws AxisFault, ThrottleComponentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting current policy configurations for the service : " + serviceName));
        }
        AxisService service = this.getAxisService(serviceName);
        ThrottlePolicy currentConfig = new ThrottlePolicy();
        AxisModule module = service.getAxisConfiguration().getModule("wso2throttle");
        currentConfig.setEngaged(service.isEngaged(module));
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(service.getPolicySubject().getAttachedPolicyComponents());
        return this.preparePolicyConfigs(assertion, currentConfig);
    }

    public ThrottlePolicy getGlobalPolicyConfigs() throws AxisFault, ThrottleComponentException {
        String globallyEngaged;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Extracting current global policy configurations");
        }
        ThrottlePolicy currentConfig = new ThrottlePolicy();
        AxisModule module = this.axisConfig.getModule("wso2throttle");
        Parameter param = module.getParameter(GLOBALLY_ENGAGED_PARAM_NAME);
        if (param != null && (globallyEngaged = (String)param.getValue()) != null && globallyEngaged.length() != 0) {
            currentConfig.setEngaged(Boolean.parseBoolean(globallyEngaged.trim()));
        }
        XmlPrimtiveAssertion assertion = this.getThrottlePolicy(module.getPolicySubject().getAttachedPolicyComponents());
        return this.preparePolicyConfigs(assertion, currentConfig);
    }

    public ThrottlePolicy getOperationPolicyConfigs(String serviceName, String operationName) throws AxisFault, ThrottleComponentException {
        AxisService service;
        AxisOperation operation;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting current policy configurations for the operation : " + operationName + " in service : " + serviceName));
        }
        if ((operation = (service = this.getAxisService(serviceName)).getOperation(new QName(operationName))) == null) {
            log.error((Object)("No operation found from the name " + operationName + ", in service : " + serviceName));
            throw new ThrottleComponentException("noSuchOperation", new String[]{serviceName});
        }
        ThrottlePolicy currentConfig = new ThrottlePolicy();
        AxisModule module = service.getAxisConfiguration().getModule("wso2throttle");
        currentConfig.setEngaged(operation.isEngaged(module) || service.isEngaged(module));
        XmlPrimtiveAssertion assertion = null;
        if (service.isEngaged(module)) {
            assertion = this.getThrottlePolicy(service.getPolicySubject().getAttachedPolicyComponents());
        }
        if (assertion == null) {
            assertion = this.getThrottlePolicy(operation.getPolicySubject().getAttachedPolicyComponents());
        }
        return this.preparePolicyConfigs(assertion, currentConfig);
    }

    public ThrottlePolicy toThrottlePolicy(String policyXML) throws ThrottleComponentException {
        try {
            OMElement policyOM = this.createOMElement(policyXML);
            Policy policy = PolicyEngine.getPolicy((OMElement)policyOM);
            ArrayList<Policy> list = new ArrayList<Policy>();
            list.add(policy);
            XmlPrimtiveAssertion assertion = this.getThrottlePolicy(list);
            return this.preparePolicyConfigs(assertion, new ThrottlePolicy());
        }
        catch (Exception e) {
            throw new ThrottleComponentException("Invalid policy XML ", e);
        }
    }

    public String throttlePolicyToString(ThrottlePolicy policy) throws ThrottleComponentException {
        OMElement policyElement = this.buildPolicy(policy, null, "mediator");
        if (policyElement != null) {
            return policyElement.toString();
        }
        return "";
    }

    private OMElement createOMElement(String xml) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private ThrottlePolicy preparePolicyConfigs(XmlPrimtiveAssertion assertion, ThrottlePolicy currentConfig) {
        ArrayList<InternalData> internalConfigs = new ArrayList<InternalData>();
        if (assertion == null) {
            return new ThrottlePolicy();
        }
        Policy throttlePolicy = PolicyEngine.getPolicy((OMElement)assertion.getValue());
        if (throttlePolicy != null) {
            for (Object inThrottle : throttlePolicy.getPolicyComponents()) {
                if (inThrottle instanceof Policy) {
                    InternalData data = new InternalData();
                    for (Object inSecondLevelPolicy : ((Policy)inThrottle).getAssertions()) {
                        if (inSecondLevelPolicy instanceof XmlPrimtiveAssertion) {
                            OMElement range = ((XmlPrimtiveAssertion)inSecondLevelPolicy).getValue();
                            data.setRange(range.getText());
                            if (!range.getAttributeValue(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME).equals("DOMAIN")) continue;
                            data.setRangeType("DOMAIN");
                            continue;
                        }
                        if (!(inSecondLevelPolicy instanceof Policy)) continue;
                        for (Object inThirdLevelPolicy : ((Policy)inSecondLevelPolicy).getPolicyComponents()) {
                            if (!(inThirdLevelPolicy instanceof XmlPrimtiveAssertion)) continue;
                            OMElement accessLevel = ((XmlPrimtiveAssertion)inThirdLevelPolicy).getValue();
                            if (accessLevel.getLocalName().equals("Allow")) {
                                data.setAccessLevel(2);
                                continue;
                            }
                            if (accessLevel.getLocalName().equals("Deny")) {
                                data.setAccessLevel(1);
                                continue;
                            }
                            data.setAccessLevel(0);
                            OMElement policy = accessLevel.getFirstChildWithName(Constants.Q_ELEM_POLICY);
                            Policy fourthLevelPolicy = PolicyEngine.getPolicy((OMElement)policy);
                            for (Object inFourthLevelPolicy : fourthLevelPolicy.getPolicyComponents()) {
                                OMElement temp = ((XmlPrimtiveAssertion)inFourthLevelPolicy).getValue();
                                String localname = temp.getLocalName();
                                if (localname.equals("MaximumCount")) {
                                    data.setMaxRequestCount(this.validateAndToInt(temp.getText()));
                                    continue;
                                }
                                if (localname.equals("UnitTime")) {
                                    data.setUnitTime(this.validateAndToInt(temp.getText()));
                                    continue;
                                }
                                if (!localname.equals("ProhibitTimePeriod")) continue;
                                data.setProhibitTimePeriod(this.validateAndToInt(temp.getText()));
                            }
                        }
                    }
                    internalConfigs.add(data);
                    continue;
                }
                if (!(inThrottle instanceof XmlPrimtiveAssertion)) continue;
                OMElement maxConc = ((XmlPrimtiveAssertion)inThrottle).getValue();
                currentConfig.setMaxConcurrentAccesses(this.validateAndToInt(maxConc.getText()));
            }
            InternalData[] data = new InternalData[internalConfigs.size()];
            for (int p = 0; p < internalConfigs.size(); ++p) {
                data[p] = (InternalData)internalConfigs.get(p);
            }
            currentConfig.setInternalConfigs(data);
        }
        return currentConfig;
    }

    private XmlPrimtiveAssertion getThrottlePolicy(Collection components) throws AxisFault {
        for (Object comp : components) {
            if (!(comp instanceof Policy)) continue;
            Policy policy = (Policy)comp;
            Iterator iterator = policy.getAlternatives();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) continue;
                List list = (List)object;
                for (Object assertObj : list) {
                    XmlPrimtiveAssertion primitiveAssertion;
                    QName assertionName;
                    if (!(assertObj instanceof XmlPrimtiveAssertion) || !(assertionName = (primitiveAssertion = (XmlPrimtiveAssertion)assertObj).getName()).equals(ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.OPERATION_THROTTLE_ASSERTION_QNAME) && !assertionName.equals(ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Existing ThrottleAssertion found");
                    }
                    this.policyToUpdate = policy;
                    return primitiveAssertion;
                }
            }
        }
        return null;
    }

    private OMElement buildPolicy(ThrottlePolicy policyConfigs, XmlPrimtiveAssertion assertion, String level) throws ThrottleComponentException {
        InternalData[] internalData;
        OMElement throttleAssertion;
        OMElement policyElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Building the policy using received configurations");
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace throttleNamespace = factory.createOMNamespace("http://www.wso2.org/products/wso2commons/throttle", "throttle");
        OMElement template = this.getTemplatePolicy(level);
        template.build();
        OMElement ta = this.getThrottleAssertion(level, template);
        OMElement secondLevelPolicy = ta.getFirstChildWithName(Constants.Q_ELEM_POLICY);
        if (assertion != null) {
            policyElement = this.getPolicyElement();
            OMElement existingElement = assertion.getValue();
            OMElement existingSecondLevelPolicy = existingElement.getFirstChildWithName(Constants.Q_ELEM_POLICY);
            while (existingSecondLevelPolicy != null) {
                existingSecondLevelPolicy.detach();
                existingSecondLevelPolicy = existingElement.getFirstChildWithName(Constants.Q_ELEM_POLICY);
            }
            policyElement.addChild((OMNode)existingElement);
            throttleAssertion = this.getThrottleAssertion(level, policyElement);
        } else {
            policyElement = template;
            throttleAssertion = ta;
        }
        QName maxName = new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumConcurrentAccess");
        OMElement tempToTreat = throttleAssertion.getFirstChildWithName(maxName);
        if (tempToTreat == null) {
            tempToTreat = OMAbstractFactory.getOMFactory().createOMElement(maxName);
            throttleAssertion.addChild((OMNode)tempToTreat);
        }
        this.treatSubElement(tempToTreat, policyConfigs.getMaxConcurrentAccesses());
        QName controlQName = new QName("http://www.wso2.org/products/wso2commons/throttle", "Control");
        for (InternalData confData : internalData = policyConfigs.getInternalConfigs()) {
            OMElement clonedElement = secondLevelPolicy.cloneOMElement();
            OMElement temp = clonedElement.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "ID"));
            temp.setText(confData.getRange());
            if (confData.getRangeType().equals("DOMAIN")) {
                temp.getAttribute(ThrottleConstants.THROTTLE_TYPE_ATTRIBUTE_QNAME).setAttributeValue("DOMAIN");
            }
            temp = clonedElement.getFirstChildWithName(Constants.Q_ELEM_POLICY);
            if (confData.getAccessLevel() == 0) {
                temp = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "Control"));
                temp = temp.getFirstChildWithName(Constants.Q_ELEM_POLICY);
                OMElement e = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumCount"));
                this.treatSubElement(e, confData.getMaxRequestCount());
                tempToTreat = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "UnitTime"));
                this.treatSubElement(tempToTreat, confData.getUnitTime());
                tempToTreat = temp.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "ProhibitTimePeriod"));
                this.treatSubElement(tempToTreat, confData.getProhibitTimePeriod());
            } else if (confData.getAccessLevel() == 2) {
                temp.getFirstChildWithName(controlQName).detach();
                temp.addChild((OMNode)factory.createOMElement("Allow", throttleNamespace));
            } else if (confData.getAccessLevel() == 1) {
                temp.getFirstChildWithName(controlQName).detach();
                temp.addChild((OMNode)factory.createOMElement("Deny", throttleNamespace));
            }
            throttleAssertion.addChild((OMNode)clonedElement);
        }
        secondLevelPolicy.detach();
        return policyElement;
    }

    private void treatSubElement(OMElement subElement, int configValue) {
        if (configValue != 0) {
            subElement.setText(String.valueOf(configValue));
        } else {
            subElement.detach();
        }
    }

    private OMElement getPolicyElement() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement policyElement = factory.createOMElement(Constants.Q_ELEM_POLICY);
        OMNamespace wsuNs = factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        policyElement.addAttribute(factory.createOMAttribute("Id", wsuNs, "DummyPolicy"));
        return policyElement;
    }

    private OMElement getTemplatePolicy(String level) throws ThrottleComponentException {
        XMLStreamReader parser;
        String resourceUri = "/repository/components/org.wso2.carbon.throttle/templates/" + level;
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (!registry.resourceExists(resourceUri)) {
                throw new ThrottleComponentException("templateNotFound");
            }
            Resource resource = registry.get(resourceUri);
            InputStream in = resource.getContentStream();
            parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
        }
        catch (Exception e) {
            log.error((Object)"Error occoured while loading template from registry", (Throwable)e);
            throw new ThrottleComponentException("errorLoadingTemplate");
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    private OMElement getThrottleAssertion(String level, OMElement parent) {
        OMElement throttleAssertion = level.equals("service") ? parent.getFirstChildWithName(ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME) : (level.equals("operation") ? parent.getFirstChildWithName(ThrottleConstants.OPERATION_THROTTLE_ASSERTION_QNAME) : (level.equals("mediator") ? parent.getFirstChildWithName(ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME) : parent.getFirstChildWithName(ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME)));
        return throttleAssertion;
    }

    private AxisService getAxisService(String serviceName) throws ThrottleComponentException {
        AxisService axisService = this.axisConfig.getServiceForActivation(serviceName);
        if (axisService == null) {
            log.error((Object)("No service found from the name " + serviceName));
            throw new ThrottleComponentException("noSuchService", new String[]{serviceName});
        }
        return axisService;
    }

    private int validateAndToInt(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (intValue == -1) {
            throw new IllegalArgumentException("Invalid parameter value : " + value + ".Expected integer value.");
        }
        return intValue;
    }
}

