/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.handlers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.wso2.caching.CachableResponse;
import org.wso2.caching.CacheReplicationCommand;
import org.wso2.caching.handlers.CachingHandler;
import org.wso2.caching.util.SOAPMessageHelper;

public class CachingOutHandler
extends CachingHandler {
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        CacheReplicationCommand cacheReplicationCommand;
        AxisModule cachingModule = msgContext.getConfigurationContext().getAxisConfiguration().getModule("wso2caching");
        if (cachingModule == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!msgContext.getAxisOperation().isEngaged(cachingModule) && !msgContext.getAxisService().isEngaged(cachingModule)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the execution of the CachingOutHandler");
        }
        if (!msgContext.isServerSide()) {
            throw new UnsupportedOperationException("Client side caching is not supported");
        }
        OperationContext opCtx = msgContext.getOperationContext();
        if (opCtx == null) {
            this.handleException("Unable to store the cached response : OperationContext not found for the processing");
        }
        assert (opCtx != null);
        CachableResponse response = (CachableResponse)opCtx.getPropertyNonReplicable("CachableResponse");
        if (response != null && response.getResponseEnvelope() == null) {
            SOAPEnvelope envelope = SOAPMessageHelper.cloneSOAPEnvelope(msgContext.getEnvelope());
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                envelope.serialize((OutputStream)outStream);
                response.setResponseEnvelope(outStream.toByteArray());
                if (response.getTimeout() > 0L) {
                    response.setExpireTimeMillis(System.currentTimeMillis() + response.getTimeout());
                }
            }
            catch (XMLStreamException e) {
                this.handleException("Unable to store the cached response : Error in serializing the response", e);
            }
        }
        if ((cacheReplicationCommand = (CacheReplicationCommand)((Object)opCtx.getPropertyNonReplicable("StateReplicationObject"))) != null) {
            try {
                Replicator.replicateState((StateClusteringCommand)cacheReplicationCommand, (AxisConfiguration)opCtx.getRootContext().getAxisConfiguration());
            }
            catch (ClusteringFault clusteringFault) {
                log.error((Object)"Cannot replicate cache changes");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

