/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.wso2.xkms2.KRSSRequest;
import org.wso2.xkms2.RevokeKeyBinding;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public class RevokeRequest
extends KRSSRequest {
    private RevokeKeyBinding revokeKeyBinding;
    private byte[] revocationCode;

    public RevokeKeyBinding getRevokeKeyBinding() {
        return this.revokeKeyBinding;
    }

    public void setRevokeKeyBinding(RevokeKeyBinding revokeKeyBinding) {
        this.revokeKeyBinding = revokeKeyBinding;
    }

    public byte[] getRevocationCode() {
        return this.revocationCode;
    }

    public void setRevocationCode(byte[] revocationCode) {
        this.revocationCode = revocationCode;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        OMElement revokeRequestElem = factory.createOMElement(XKMS2Constants.Q_ELEM_REVOKE_REQUEST);
        super.serialize(factory, revokeRequestElem);
        revokeRequestElem.addChild((OMNode)this.revokeKeyBinding.serialize(factory));
        if (revokeRequestElem.getFirstChildWithName(XKMS2Constants.Q_ELEM_AUTHENTICATION) == null) {
            if (this.revocationCode != null) {
                OMElement revocationCodeElem = factory.createOMElement(XKMS2Constants.Q_ELEM_REVOCATION_CODE, (OMContainer)revokeRequestElem);
                DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(this.revocationCode));
                OMText text = factory.createOMText((Object)dataHandler, false);
                revocationCodeElem.addChild((OMNode)text);
            } else {
                throw new XKMSException("RevocationCode or Authentication is not set");
            }
        }
        return revokeRequestElem;
    }
}

