/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.wso2.xkms2.MessageAbstractType;
import org.wso2.xkms2.RequestSignatureValue;
import org.wso2.xkms2.ResultMajor;
import org.wso2.xkms2.ResultMinor;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public class ResultType
extends MessageAbstractType {
    private RequestSignatureValue requestSignatureValue;
    private ResultMajor resultMajor;
    private ResultMinor resultMinor;
    private String requestId;

    public RequestSignatureValue getRequestSignatureValue() {
        return this.requestSignatureValue;
    }

    public void setRequestSignatureValue(RequestSignatureValue requestSignatureValue) {
        this.requestSignatureValue = requestSignatureValue;
    }

    public ResultMajor getResultMajor() {
        return this.resultMajor;
    }

    public void setResultMajor(ResultMajor resultMajor) {
        this.resultMajor = resultMajor;
    }

    public ResultMinor getResultMinor() {
        return this.resultMinor;
    }

    public void setResultMinor(ResultMinor resultMinor) {
        this.resultMinor = resultMinor;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    protected void serialize(OMFactory factory, OMElement container) throws XKMSException {
        super.serialize(factory, container);
        OMNamespace emptyNs = factory.createOMNamespace("", "");
        if (this.requestSignatureValue != null) {
            OMElement requestSignatureValueEle = factory.createOMElement(XKMS2Constants.ELE_REQUEST_SIGNATURE_VALUE);
            DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(this.requestSignatureValue.getBase64Binary()));
            OMTextImpl omText = new OMTextImpl((Object)dataHandler, true, factory);
            requestSignatureValueEle.addChild((OMNode)omText);
            String id = this.requestSignatureValue.getId();
            if (id != null) {
                requestSignatureValueEle.addAttribute("Id", id, emptyNs);
            }
            container.addChild((OMNode)requestSignatureValueEle);
        }
        if (this.resultMajor == null) {
            throw new XKMSException("ResultMajor is not found");
        }
        container.addAttribute("ResultMajor", this.resultMajor.getAnyURI(), emptyNs);
        if (this.resultMinor != null) {
            container.addAttribute("ResultMinor", this.resultMinor.getAnyURI(), emptyNs);
        }
        if (this.requestId != null) {
            container.addAttribute("RequestId", this.requestId, emptyNs);
        }
    }
}

