/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStoreMgtUtil {
    private static Log log = LogFactory.getLog(KeyStoreMgtUtil.class);

    public static String dumpCert(ConfigurationContext configurationContext, byte[] cert, String fileName) {
        if (!KeyStoreMgtUtil.verifyCertExistence(fileName, configurationContext)) {
            String workDir = (String)configurationContext.getProperty("WORK_DIR");
            File pubCert = new File(workDir + File.separator + "pub_certs");
            if (fileName == null) {
                fileName = String.valueOf((double)System.currentTimeMillis() + Math.random()) + ".cert";
            }
            if (!pubCert.exists()) {
                pubCert.mkdirs();
            }
            String filePath = workDir + File.separator + "pub_certs" + File.separator + fileName;
            try {
                FileOutputStream outStream = new FileOutputStream(filePath);
                ((OutputStream)outStream).write(cert);
                outStream.flush();
                ((OutputStream)outStream).close();
            }
            catch (Exception e) {
                String msg = "Error when writing the public certificate to a file";
                log.error((Object)msg);
                throw new SecurityException("msg", e);
            }
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)configurationContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                configurationContext.setProperty("file.resource.map", fileResourcesMap);
            }
            fileResourcesMap.put(fileName, filePath);
        }
        return "/filedownload?id=" + fileName;
    }

    private static boolean verifyCertExistence(String fileName, ConfigurationContext configurationContext) {
        String workDir = (String)configurationContext.getProperty("WORK_DIR");
        File pubCert = new File(workDir + File.separator + "pub_certs" + File.separator + fileName);
        if (pubCert.exists()) {
            Hashtable<String, File> fileResourcesMap = (Hashtable<String, File>)configurationContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, File>();
                configurationContext.setProperty("file.resource.map", fileResourcesMap);
            }
            if (fileResourcesMap.get(fileName) == null) {
                fileResourcesMap.put(fileName, pubCert);
            }
            return true;
        }
        return false;
    }
}

