/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.module.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.services.authentication.AbstractAuthenticator;
import org.wso2.carbon.core.services.authentication.AuthenticationFailureException;
import org.wso2.carbon.core.services.authentication.BackendAuthenticator;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.core.services.authentication.ServerAuthenticator;
import org.wso2.carbon.server.admin.auth.AuthenticatorServerRegistry;

public class AuthenticationHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(AuthenticationHandler.class);
    private static final Log audit = CarbonConstants.AUDIT_LOG;

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        HttpSession session;
        if ("local".equals(msgContext.getIncomingTransportName()) || this.callToGeneralService(msgContext) || this.skipAuthentication(msgContext)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        this.authenticate(msgContext, (String)msgContext.getProperty("REMOTE_ADDR"));
        if (!AbstractAuthenticator.continueProcessing((MessageContext)msgContext)) {
            return Handler.InvocationResponse.ABORT;
        }
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null && (session = request.getSession(false)) != null) {
            String domain = (String)session.getAttribute("tenantDomain");
            if (domain != null) {
                msgContext.setProperty("tenantDomain", (Object)domain);
                PrivilegedCarbonContext.getCurrentContext().setTenantDomain(domain);
            }
            String username = (String)session.getAttribute("wso2carbon.admin.logged.in");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected void authenticate(MessageContext msgContext, String remoteIP) throws AxisFault {
        try {
            if (!this.isAuthenticated(msgContext, remoteIP) && AbstractAuthenticator.continueProcessing((MessageContext)msgContext)) {
                throw new AxisFault("Access Denied. Please login first.", "50977");
            }
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (AuthenticationFailureException e) {
            if (AbstractAuthenticator.continueProcessing((MessageContext)msgContext)) {
                if (e.getAuthenticationFailureReason() == AuthenticationFailureException.AuthenticationFailureReason.INVALID_USER_NAME || e.getAuthenticationFailureReason() == AuthenticationFailureException.AuthenticationFailureReason.INVALID_PASSWORD) {
                    AxisFault axisFault = new AxisFault("Access Denied. " + e.getMessage(), "50977");
                    axisFault.setFaultType(1);
                    throw axisFault;
                }
                throw new AxisFault("Access Denied. " + e.getMessage(), "50976");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new AxisFault("Authentication failure", "50977");
        }
    }

    protected boolean isRestrictedOperation(MessageContext msgContext) {
        AxisOperation operation = msgContext.getAxisOperation();
        Parameter authenticationParameter = operation.getParameter("DoAuthentication");
        return authenticationParameter == null || !"false".equals(authenticationParameter.getValue());
    }

    private String getServiceName(MessageContext msgContext) {
        AxisService service = msgContext.getAxisService();
        return service.getName();
    }

    private boolean isAuthenticated(MessageContext msgContext, String remoteIP) throws AuthenticationFailureException {
        boolean isAuthenticated;
        if (!this.isRestrictedOperation(msgContext)) {
            return true;
        }
        BackendAuthenticator authenticator = AuthenticatorServerRegistry.getCarbonAuthenticator(msgContext);
        if (authenticator == null) {
            String message = "System error : 0 active authenticators registered in the system. The system should have at least 1 active authenticator service registered.";
            throw new RuntimeException(message);
        }
        if (authenticator instanceof ServerAuthenticator) {
            ServerAuthenticator serverAuthenticator = (ServerAuthenticator)authenticator;
            isAuthenticated = serverAuthenticator.isAuthenticated(msgContext);
            if (!isAuthenticated) {
                try {
                    serverAuthenticator.authenticate(msgContext);
                    return true;
                }
                catch (AuthenticationFailureException e) {
                    SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
                    this.invalidateSession(msgContext);
                    String serviceName = this.getServiceName(msgContext);
                    String msg = "Illegal access attempt at " + date.format(new Date()) + " from IP address " + remoteIP + " while trying to authenticate access to service " + serviceName;
                    log.warn((Object)msg);
                    audit.error((Object)msg);
                    throw e;
                }
            }
        } else {
            CarbonServerAuthenticator carbonServerAuthenticator = (CarbonServerAuthenticator)authenticator;
            isAuthenticated = carbonServerAuthenticator.isAuthenticated(msgContext);
            if (!isAuthenticated) {
                isAuthenticated = carbonServerAuthenticator.authenticateWithRememberMe(msgContext);
                SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
                this.invalidateSession(msgContext);
                if (AbstractAuthenticator.continueProcessing((MessageContext)msgContext)) {
                    String serviceName = this.getServiceName(msgContext);
                    String msg = "Illegal access attempt at " + date.format(new Date()) + " from IP address " + remoteIP + " : Service is " + serviceName;
                    log.warn((Object)msg);
                    audit.warn((Object)msg);
                }
            }
        }
        return isAuthenticated;
    }

    private void invalidateSession(MessageContext msgContext) {
        HttpSession session;
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request == null && (session = request.getSession()) != null) {
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                log.debug((Object)"Unable to invalidate session ", (Throwable)e);
            }
        }
    }

    private boolean callToGeneralService(MessageContext msgContext) {
        boolean isGeneral = true;
        AxisService service = msgContext.getAxisService();
        Parameter param = service.getParameter("adminService");
        if (param != null && "true".equals(param.getValue())) {
            isGeneral = false;
        }
        return isGeneral;
    }

    private boolean skipAuthentication(MessageContext msgContext) {
        boolean skipAuth = false;
        AxisService service = msgContext.getAxisService();
        Parameter param = service.getParameter("DoAuthentication");
        if (param != null && "false".equals(param.getValue())) {
            skipAuth = true;
        }
        return skipAuth;
    }
}

