/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.privilegedaction.extension;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.server.admin.privilegedaction.extension.PrivilegedActionExtension;
import org.wso2.carbon.server.admin.privilegedaction.extension.PrivilegedActionExtensionComparator;

public class PrivilegedActionExtensionRegistry {
    private static Log log = LogFactory.getLog(PrivilegedActionExtensionRegistry.class);
    private static ServiceTracker extensionTracker;

    public static void init(BundleContext bc) throws Exception {
        try {
            extensionTracker = new ServiceTracker(bc, PrivilegedActionExtension.class.getName(), null);
            extensionTracker.open();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static ArrayList<PrivilegedActionExtension> getPrivilegedActionExtensions(MessageContext msgContext) {
        Object[] objects = extensionTracker.getServices();
        if (objects == null) {
            return null;
        }
        ArrayList<PrivilegedActionExtension> extensions = new ArrayList<PrivilegedActionExtension>();
        PrivilegedActionExtension ext = null;
        for (Object obj : objects) {
            ext = (PrivilegedActionExtension)obj;
            if (ext.isDisabled() || !ext.isHandle(msgContext)) continue;
            extensions.add(ext);
        }
        Collections.sort(extensions, new PrivilegedActionExtensionComparator());
        return extensions;
    }
}

