/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.ui.client;

import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.service.builtin.SequenceMediator;
import org.wso2.carbon.sequences.common.SequenceEditorException;
import org.wso2.carbon.sequences.common.to.ConfigurationObject;
import org.wso2.carbon.sequences.stub.types.SequenceAdminServiceStub;
import org.wso2.carbon.sequences.stub.types.common.to.SequenceInfo;
import org.wso2.carbon.sequences.ui.client.EditorUIClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SequenceAdminClient
implements EditorUIClient {
    private static final Log log = LogFactory.getLog(SequenceAdminClient.class);
    private SequenceAdminServiceStub sequenceAdminStub;

    public SequenceAdminClient(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "SequenceAdminService";
        this.sequenceAdminStub = new SequenceAdminServiceStub(configContext, serviceURL);
        ServiceClient client = this.sequenceAdminStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    @Override
    public org.wso2.carbon.sequences.common.to.SequenceInfo[] getSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        ArrayList<org.wso2.carbon.sequences.common.to.SequenceInfo> sequences = new ArrayList<org.wso2.carbon.sequences.common.to.SequenceInfo>();
        try {
            SequenceInfo[] temp = this.sequenceAdminStub.getSequences(pageNumber, sequencePerPage);
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (SequenceInfo info : temp) {
                org.wso2.carbon.sequences.common.to.SequenceInfo seqInfo = new org.wso2.carbon.sequences.common.to.SequenceInfo();
                seqInfo.setEnableStatistics(info.getEnableStatistics());
                seqInfo.setEnableTracing(info.getEnableTracing());
                seqInfo.setName(info.getName());
                seqInfo.setDescription(info.getDescription());
                sequences.add(seqInfo);
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the information of the sequences", e);
        }
        if (sequences.size() > 0) {
            return sequences.toArray(new org.wso2.carbon.sequences.common.to.SequenceInfo[sequences.size()]);
        }
        return null;
    }

    @Override
    public int getSequencesCount() throws SequenceEditorException {
        try {
            return this.sequenceAdminStub.getSequencesCount();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the sequence element count", e);
            return 0;
        }
    }

    private OMElement getSequence(String sequenceName) throws SequenceEditorException {
        OMElement element = null;
        try {
            element = this.sequenceAdminStub.getSequence(sequenceName).getFirstElement();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the sequence element with name '" + sequenceName + "'", e);
        }
        return element;
    }

    public void saveSequence(SequenceMediator sequence) throws SequenceEditorException {
        OMElement sequenceElem = sequence.serialize(null);
        try {
            this.sequenceAdminStub.saveSequence(sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in saving the sequence with the configuration '" + sequenceElem + "'", e);
        }
    }

    public void addSequence(SequenceMediator sequence) throws SequenceEditorException {
        OMElement sequenceElem = sequence.serialize(null);
        try {
            this.sequenceAdminStub.addSequence(sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in adding the sequence with the configuration '" + sequenceElem + "'", e);
        }
    }

    public void addDynamicSequence(String key, SequenceMediator sequence) throws SequenceEditorException {
        OMElement sequenceElem = sequence.serialize(null);
        try {
            this.sequenceAdminStub.addDynamicSequence(key, sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in adding dynamic sequence with configuration '" + sequenceElem + "' to the registry with key '" + key + "'", e);
        }
    }

    @Override
    public OMElement getDynamicSequence(String key) throws SequenceEditorException {
        OMElement dynamicSequence = null;
        try {
            dynamicSequence = this.sequenceAdminStub.getDynamicSequence(key);
        }
        catch (Exception e) {
            this.handleException("Couldn't get dynamic sequence with key '" + key + "'", e);
        }
        return dynamicSequence;
    }

    @Override
    public void saveDynamicSequence(String key, SequenceMediator sequence) throws SequenceEditorException {
        OMElement sequenceElem = sequence.serialize(null);
        try {
            this.sequenceAdminStub.saveDynamicSequence(key, sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Error in saving dynamic sequence with configuration '" + sequenceElem + "' for key '" + key + "'", e);
        }
    }

    @Override
    public String enableTracing(String sequenceName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.sequenceAdminStub.enableTracing(sequenceName);
        }
        catch (Exception e) {
            this.handleException("Couldn't enable tracing for the sequence '" + sequenceName + "'", e);
        }
        return state;
    }

    @Override
    public String disableTracing(String sequenceName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.sequenceAdminStub.disableTracing(sequenceName);
        }
        catch (Exception e) {
            this.handleException("Couldn't disable tracing for the sequence '" + sequenceName + "'", e);
        }
        return state;
    }

    @Override
    public String enableStatistics(String sequenceName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.sequenceAdminStub.enableStatistics(sequenceName);
        }
        catch (Exception e) {
            this.handleException("Couldn't enable statistics for the sequence '" + sequenceName + "'", e);
        }
        return state;
    }

    @Override
    public String disableStatistics(String sequenceName) throws SequenceEditorException {
        String state = null;
        try {
            state = this.sequenceAdminStub.disableStatistics(sequenceName);
        }
        catch (Exception e) {
            this.handleException("Couldn't disable statistics for the sequence '" + sequenceName + "'", e);
        }
        return state;
    }

    @Override
    public void deleteSequence(String sequenceName) throws SequenceEditorException {
        try {
            this.sequenceAdminStub.deleteSequence(sequenceName);
        }
        catch (Exception e) {
            this.handleException("Couldn't delete the sequence '" + sequenceName + "'", e);
        }
    }

    @Override
    public String getEntryNamesString() throws SequenceEditorException {
        String localRegistryKeys = null;
        try {
            localRegistryKeys = this.sequenceAdminStub.getEntryNamesString();
        }
        catch (Exception e) {
            this.handleException("Couldn't get local registry Keys", e);
        }
        return localRegistryKeys;
    }

    @Override
    public void updateDynamicSequence(String key, SequenceMediator sequence) throws SequenceEditorException {
        try {
            OMElement sequenceElem = sequence.serialize(null);
            this.sequenceAdminStub.updateDynamicSequence(key, sequenceElem);
        }
        catch (Exception e) {
            this.handleException("Couldn't update sequence with key '" + key + "'", e);
        }
    }

    @Override
    public void deleteDynamicSequence(String key) throws SequenceEditorException {
        try {
            this.sequenceAdminStub.deleteDynamicSequence(key);
        }
        catch (Exception e) {
            this.handleException("Couldn't delete sequence with key '" + key + "'", e);
        }
    }

    @Override
    public org.wso2.carbon.sequences.common.to.SequenceInfo[] getDynamicSequences(int pageNumber, int sequencePerPage) throws SequenceEditorException {
        ArrayList<org.wso2.carbon.sequences.common.to.SequenceInfo> sequences = new ArrayList<org.wso2.carbon.sequences.common.to.SequenceInfo>();
        try {
            SequenceInfo[] temp = this.sequenceAdminStub.getDynamicSequences(pageNumber, sequencePerPage);
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (SequenceInfo info : temp) {
                org.wso2.carbon.sequences.common.to.SequenceInfo seqInfo = new org.wso2.carbon.sequences.common.to.SequenceInfo();
                seqInfo.setName(info.getName());
                sequences.add(seqInfo);
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the information of the sequences", e);
        }
        if (sequences.size() > 0) {
            return sequences.toArray(new org.wso2.carbon.sequences.common.to.SequenceInfo[sequences.size()]);
        }
        return null;
    }

    @Override
    public int getDynamicSequenceCount() throws SequenceEditorException {
        try {
            return this.sequenceAdminStub.getDynamicSequenceCount();
        }
        catch (Exception e) {
            this.handleException("Couldn't retrieve the dynamic sequence element count", e);
            return 0;
        }
    }

    @Override
    public ConfigurationObject[] getDependents(String sequence) throws SequenceEditorException {
        try {
            org.wso2.carbon.sequences.stub.types.common.to.ConfigurationObject[] tempDependents = this.sequenceAdminStub.getDependents(sequence);
            if (tempDependents != null && tempDependents.length > 0 && tempDependents[0] != null) {
                ConfigurationObject[] dependents = new ConfigurationObject[tempDependents.length];
                for (int i = 0; i < dependents.length; ++i) {
                    dependents[i] = new ConfigurationObject(tempDependents[i].getType(), tempDependents[i].getResourceId());
                }
                return dependents;
            }
        }
        catch (Exception e) {
            this.handleException("Couldn't get the dependents for the sequence : " + sequence, e);
        }
        return null;
    }

    @Override
    public SequenceMediator getSequenceMediator(String sequenceName) throws SequenceEditorException {
        OMElement ele = this.getSequence(sequenceName);
        if (ele != null) {
            SequenceMediator sequence = new SequenceMediator();
            sequence.build(ele);
            return sequence;
        }
        return null;
    }

    private void handleException(String message, Throwable e) throws SequenceEditorException {
        log.error((Object)message, e);
        throw new SequenceEditorException(message, e);
    }
}

