/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sequences.ui.util.ns;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.sequences.ui.util.SequenceEditorHelper;
import org.wso2.carbon.sequences.ui.util.ns.NameSpacesInformation;
import org.wso2.carbon.sequences.ui.util.ns.NameSpacesInformationRepository;

public class QNameFactory {
    private static final Log log = LogFactory.getLog(QNameFactory.class);
    private static final QNameFactory ourInstance = new QNameFactory();

    public static QNameFactory getInstance() {
        return ourInstance;
    }

    private QNameFactory() {
    }

    public QName createQName(String id, String localName, HttpSession httpSession) {
        Iterator<String> iterator;
        if (!QNameFactory.assertIDNotEmpty(id) || !QNameFactory.assertLocalNameNotEmpty(localName)) {
            return null;
        }
        NameSpacesInformationRepository repository = (NameSpacesInformationRepository)httpSession.getAttribute("NameSpacesInformationRepository");
        if (repository == null) {
            return new QName(localName);
        }
        NameSpacesInformation information = repository.getNameSpacesInformation(SequenceEditorHelper.getEditingMediatorPosition(httpSession), id);
        if (information == null) {
            return new QName(localName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting NameSpaces :" + information + " for id :" + id));
        }
        if ((iterator = information.getPrefixes()).hasNext()) {
            String prefix = iterator.next();
            String uri = information.getNameSpaceURI(prefix);
            if (uri == null) {
                uri = "";
            }
            if (prefix == null) {
                prefix = "";
            }
            return new QName(uri, localName, prefix);
        }
        information.removeAllNameSpaces();
        return new QName(localName);
    }

    public QName createQName(String id, HttpServletRequest request, HttpSession httpSession) {
        return this.createQName(id, request.getParameter(id), httpSession);
    }

    private static boolean assertIDNotEmpty(String id) {
        if (id == null || "".equals(id)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided id is empty or null ,returning a null as QName");
            }
            return false;
        }
        return true;
    }

    private static boolean assertLocalNameNotEmpty(String source) {
        if (source == null || "".equals(source)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided Localname is empty or null ,returning a null as QName");
            }
            return false;
        }
        return true;
    }
}

