/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.deployment;

import java.util.HashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.deployment.SecurityDeploymentInterceptor;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class SecurityDeploymentListener
extends AbstractAxis2ConfigurationContextObserver {
    private static Log log = LogFactory.getLog(SecurityDeploymentListener.class);

    public void createdConfigurationContext(ConfigurationContext configCtx) {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        int tenantId = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getTenantId();
        SecurityDeploymentInterceptor secDeployInterceptor = new SecurityDeploymentInterceptor();
        secDeployInterceptor.init(axisConfig);
        axisConfig.addObservers((AxisObserver)secDeployInterceptor);
        HashMap<String, Resource> policyResourceMap = SecurityServiceHolder.getPolicyResourceMap();
        try {
            UserRegistry registry = SecurityServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            for (String resourceLoc : policyResourceMap.keySet()) {
                if (registry.resourceExists(resourceLoc)) continue;
                registry.put(resourceLoc, policyResourceMap.get(resourceLoc));
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            String errorMsg = "Error when storing the policy resource in registry for tenant : " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
        }
    }
}

