/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.deployment;

import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConstants;
import org.wso2.carbon.security.SecurityScenario;
import org.wso2.carbon.security.SecurityScenarioDatabase;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.deployment.SecurityDeploymentListener;
import org.wso2.carbon.security.util.RahasUtil;
import org.wso2.carbon.security.util.ServerCrypto;
import org.wso2.carbon.security.util.ServicePasswordCallbackHandler;
import org.wso2.carbon.security.util.XmlConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.PreAxisConfigurationPopulationObserver;

public class SecurityDeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog(SecurityDeploymentInterceptor.class);
    private PersistenceFactory persistenceFactory;
    private ServiceGroupFilePersistenceManager serviceGroupFilePM;
    private ModuleFilePersistenceManager moduleFilePM;

    protected void activate(ComponentContext ctxt) {
        BundleContext bundleCtx = ctxt.getBundleContext();
        try {
            this.loadSecurityScenarios((Registry)SecurityServiceHolder.getRegistryService().getConfigSystemRegistry(), bundleCtx);
        }
        catch (Exception e) {
            String msg = "Cannot load security scenarios";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        try {
            this.addKeystores();
        }
        catch (Exception e) {
            String msg = "Cannot add keystores";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        Properties props = new Properties();
        props.put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
        bundleCtx.registerService(AxisObserver.class.getName(), (Object)this, (Dictionary)props);
        PreAxisConfigurationPopulationObserver preAxisConfigObserver = new PreAxisConfigurationPopulationObserver(){

            public void createdAxisConfiguration(AxisConfiguration axisConfiguration) {
                SecurityDeploymentInterceptor.this.init(axisConfiguration);
                axisConfiguration.addObservers((AxisObserver)SecurityDeploymentInterceptor.this);
            }
        };
        bundleCtx.registerService(PreAxisConfigurationPopulationObserver.class.getName(), (Object)preAxisConfigObserver, null);
        Properties properties = new Properties();
        properties.put("org.apache.axis2.osgi.config.service", Axis2ConfigurationContextObserver.class.getName());
        bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new SecurityDeploymentListener(), (Dictionary)properties);
    }

    public void init(AxisConfiguration axisConfig) {
        try {
            this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)axisConfig);
            this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
            this.moduleFilePM = this.persistenceFactory.getModuleFilePM();
        }
        catch (AxisFault e) {
            log.error((Object)"Error while adding PersistenceFactory parameter to axisConfig", (Throwable)e);
        }
    }

    public void moduleUpdate(AxisEvent event, AxisModule module) {
    }

    public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
    }

    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        int eventType = axisEvent.getEventType();
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        if (eventType == 1) {
            try {
                boolean isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
                if (!isTransactionStarted) {
                    this.serviceGroupFilePM.beginTransaction(serviceGroupId);
                }
                String policyResourcePath = PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "policies" + "/" + "policy";
                int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisService)axisService).getTenantId();
                if (!this.serviceGroupFilePM.elementExists(serviceGroupId, policyResourcePath)) {
                    if (!isTransactionStarted) {
                        this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                    }
                    return;
                }
                List policies = this.serviceGroupFilePM.getAll(serviceGroupId, policyResourcePath);
                SecurityScenario scenario = null;
                for (Object node : policies) {
                    OMElement policyWrapperElement = (OMElement)node;
                    String policyId = PersistenceUtils.getPolicyUUIDFromWrapperOM((OMElement)policyWrapperElement);
                    if (policyId != null) {
                        scenario = SecurityScenarioDatabase.getByWsuId(policyId);
                        if (scenario == null) continue;
                        break;
                    }
                    log.error((Object)"Policy UUID is not found though a policy element exist.");
                }
                if (scenario != null) {
                    this.applySecurityParameters(axisService, scenario);
                }
                if (!isTransactionStarted) {
                    this.serviceGroupFilePM.commitTransaction(serviceGroupId);
                }
            }
            catch (Exception e) {
                String msg = "Cannot handle service DEPLOY event for service: " + axisService.getName();
                log.error((Object)msg, (Throwable)e);
                this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                throw new RuntimeException(msg, e);
            }
        }
    }

    private void loadSecurityScenarios(Registry registry, BundleContext bundleContext) throws Exception {
        URL resource = bundleContext.getBundle().getResource("/scenarios/scenario-config.xml");
        XmlConfiguration xmlConfiguration = new XmlConfiguration(resource.openStream(), "http://www.wso2.org/products/carbon/security");
        OMElement[] elements = xmlConfiguration.getElements("//ns:Scenario");
        try {
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            for (OMElement scenarioEle : elements) {
                SecurityScenario scenario = new SecurityScenario();
                String scenarioId = scenarioEle.getAttribute(SecurityConstants.ID_QN).getAttributeValue();
                scenario.setScenarioId(scenarioId);
                scenario.setSummary(scenarioEle.getFirstChildWithName(SecurityConstants.SUMMARY_QN).getText());
                scenario.setDescription(scenarioEle.getFirstChildWithName(SecurityConstants.DESCRIPTION_QN).getText());
                scenario.setCategory(scenarioEle.getFirstChildWithName(SecurityConstants.CATEGORY_QN).getText());
                scenario.setWsuId(scenarioEle.getFirstChildWithName(SecurityConstants.WSUID_QN).getText());
                scenario.setType(scenarioEle.getFirstChildWithName(SecurityConstants.TYPE_QN).getText());
                String resourceUri = "/repository/components/org.wso2.carbon.security.mgt/policy/" + scenarioId;
                Iterator modules = scenarioEle.getFirstChildWithName(SecurityConstants.MODULES_QN).getChildElements();
                while (modules.hasNext()) {
                    String module = ((OMElement)modules.next()).getText();
                    scenario.addModule(module);
                }
                SecurityScenarioDatabase.put(scenarioId, scenario);
                if (scenarioId.equals("DisableSecurity") || scenarioId.equals("policyFromRegistry")) continue;
                ResourceImpl scenarioResource = new ResourceImpl();
                scenarioResource.setContentStream(bundleContext.getBundle().getResource("scenarios/" + scenarioId + "-policy.xml").openStream());
                if (!registry.resourceExists(resourceUri)) {
                    registry.put(resourceUri, (Resource)scenarioResource);
                }
                SecurityServiceHolder.addPolicyResource(resourceUri, (Resource)scenarioResource);
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }

    private void addKeystores() throws Exception {
        UserRegistry registry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry();
        try {
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            if (!registry.resourceExists("/repository/security/key-stores")) {
                Collection kstores = registry.newCollection();
                registry.put("/repository/security/key-stores", (Resource)kstores);
                Resource primResource = registry.newResource();
                if (!registry.resourceExists("/repository/security/key-stores/carbon-primary-ks")) {
                    registry.put("/repository/security/key-stores/carbon-primary-ks", primResource);
                }
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }

    private void applySecurityParameters(AxisService service, SecurityScenario secScenario) {
        block4: {
            try {
                OMElement serviceElement;
                String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
                String serviceName = service.getName();
                ServiceGroupFilePersistenceManager sfpm = this.persistenceFactory.getServiceGroupFilePM();
                SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext((AxisService)service);
                int tenantID = carbonContext.getTenantId();
                String tenantDomain = carbonContext.getTenantDomain(true);
                String registryServicePath = "/repository/axis2/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
                String serviceXPath = "/service" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)serviceName);
                UserRealm userRealm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)SecurityServiceHolder.getRegistryService(), (RealmService)SecurityServiceHolder.getRealmService(), (String)tenantDomain);
                UserRegistry govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantID);
                ServicePasswordCallbackHandler handler = new ServicePasswordCallbackHandler(this.persistenceFactory, serviceGroupId, serviceName, serviceXPath, registryServicePath, (Registry)govRegistry, userRealm);
                Parameter param = new Parameter();
                param.setName("passwordCallbackRef");
                param.setValue((Object)handler);
                service.addParameter(param);
                if (!secScenario.getScenarioId().equals("scenario1")) {
                    Parameter param2 = new Parameter();
                    param2.setName("disableREST");
                    param2.setValue((Object)Boolean.TRUE.toString());
                    service.addParameter(param2);
                }
                if ((serviceElement = (OMElement)sfpm.get(serviceGroupId, serviceXPath)).getAttributeValue(new QName("rahas.sctissuer")) == null) break block4;
                Object[] pvtStores = sfpm.getAll(serviceGroupId, "/service" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)serviceName) + "/" + "association" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"service-keystore")).toArray();
                Properties cryptoProps = new Properties();
                if (pvtStores != null && pvtStores.length > 0) {
                    ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                    String pvtStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
                    String keyAlias = null;
                    String name = null;
                    keyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
                    name = pvtStore.substring(pvtStore.lastIndexOf("/") + 1);
                    cryptoProps.setProperty("org.wso2.carbon.security.crypto.privatestore", name);
                    cryptoProps.setProperty("org.wso2.carbon.security.crypto.alias", keyAlias);
                    service.addParameter(RahasUtil.getSCTIssuerConfigParameter(ServerCrypto.class.getName(), cryptoProps, -1, null, true, true));
                    service.addParameter(RahasUtil.getTokenCancelerConfigParameter());
                    break block4;
                }
                throw new Exception("Cannot start Rahas");
            }
            catch (Throwable e) {
                String msg = "Cannot apply security parameters";
                log.error((Object)msg, e);
            }
        }
    }

    public void addParameter(Parameter param) throws AxisFault {
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
    }

    public Parameter getParameter(String name) {
        return null;
    }

    public ArrayList getParameters() {
        return new ArrayList();
    }

    public boolean isParameterLocked(String parameterName) {
        return false;
    }

    public void removeParameter(Parameter param) throws AxisFault {
    }

    protected void setRegistryService(RegistryService registryService) {
        SecurityServiceHolder.setRegistryService(registryService);
    }

    protected void setRealmService(RealmService realmService) {
        SecurityServiceHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        SecurityServiceHolder.setRealmService(null);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        SecurityServiceHolder.setRegistryService(registryService);
    }
}

