/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.config;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.Token;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.SecurityConstants;
import org.wso2.carbon.security.SecurityScenario;
import org.wso2.carbon.security.SecurityScenarioDatabase;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.config.SecurityServiceAdmin;
import org.wso2.carbon.security.config.service.KerberosConfigData;
import org.wso2.carbon.security.config.service.SecurityConfigData;
import org.wso2.carbon.security.config.service.SecurityScenarioData;
import org.wso2.carbon.security.util.RahasUtil;
import org.wso2.carbon.security.util.RampartConfigUtil;
import org.wso2.carbon.security.util.SecurityTokenStore;
import org.wso2.carbon.security.util.ServerCrypto;
import org.wso2.carbon.security.util.ServicePasswordCallbackHandler;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.ServerException;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class SecurityConfigAdmin {
    private static Log log = LogFactory.getLog(SecurityConfigAdmin.class);
    public static final String USER = "rampart.config.user";
    private AxisConfiguration axisConfig = null;
    private CallbackHandler callback = null;
    private Registry registry = null;
    private UserRegistry govRegistry = null;
    private UserRealm realm = null;
    private PersistenceFactory persistenceFactory;
    private ServiceGroupFilePersistenceManager serviceGroupFilePM;
    private ModuleFilePersistenceManager moduleFilePM;

    public SecurityConfigAdmin(AxisConfiguration config) throws SecurityConfigException {
        this.axisConfig = config;
        try {
            this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)config);
            this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
            this.moduleFilePM = this.persistenceFactory.getModuleFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error creating an PersistenceFactory instance", (Throwable)e);
            throw new SecurityConfigException("Error creating an PersistenceFactory instance", e);
        }
        try {
            this.registry = SecurityServiceHolder.getRegistryService().getConfigSystemRegistry();
            this.govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry();
        }
        catch (Exception e) {
            String msg = "Error when retrieving a registry instance";
            log.error((Object)msg);
            throw new SecurityConfigException(msg, e);
        }
    }

    public SecurityConfigAdmin(AxisConfiguration config, Registry reg, CallbackHandler cb) {
        this.axisConfig = config;
        this.registry = reg;
        this.callback = cb;
        try {
            this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)config);
            this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
            this.moduleFilePM = this.persistenceFactory.getModuleFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error creating an PersistenceFactory instance", (Throwable)e);
        }
        try {
            this.govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(((UserRegistry)reg).getTenantId());
        }
        catch (Exception e) {
            log.error((Object)"Error when obtaining the governance registry instance.");
        }
    }

    public SecurityConfigAdmin(UserRealm realm, Registry registry, AxisConfiguration config) throws SecurityConfigException {
        this.axisConfig = config;
        this.registry = registry;
        this.realm = realm;
        try {
            this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)config);
            this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
            this.moduleFilePM = this.persistenceFactory.getModuleFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error creating an PersistenceFactory instance", (Throwable)e);
            throw new SecurityConfigException("Error creating an PersistenceFactory instance", e);
        }
        try {
            this.govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(((UserRegistry)registry).getTenantId());
        }
        catch (Exception e) {
            log.error((Object)"Error when obtaining the governance registry instance.");
            throw new SecurityConfigException("Error when obtaining the governance registry instance.", e);
        }
    }

    public SecurityScenarioData getSecurityScenario(String sceneId) throws SecurityConfigException {
        SecurityScenarioData data = null;
        SecurityScenario scenario = SecurityScenarioDatabase.get(sceneId);
        if (scenario != null) {
            data = new SecurityScenarioData();
            data.setCategory(scenario.getCategory());
            data.setDescription(scenario.getDescription());
            data.setScenarioId(scenario.getScenarioId());
            data.setSummary(scenario.getSummary());
        }
        return data;
    }

    public SecurityScenarioData getCurrentScenario(String serviceName) throws SecurityConfigException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String serviceGroupId = null;
        try {
            String serviceXPath;
            String policyResourcePath;
            boolean isTransactionStarted;
            SecurityScenarioData data = null;
            if (service == null) {
                try {
                    service = (AxisService)GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.axisConfig).get(serviceName);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error while reading Transit Ghosts map", (Throwable)axisFault);
                }
                if (service == null) {
                    throw new SecurityConfigException("AxisService is Null");
                }
            }
            if (!(isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId = service.getAxisServiceGroup().getServiceGroupName()))) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, policyResourcePath = (serviceXPath = PersistenceUtils.getResourcePath((AxisService)service)) + "/" + "policies" + "/" + "policy")) {
                if (!isTransactionStarted) {
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                }
                return data;
            }
            Parameter param = service.getParameter("secPolicyRegistryPath");
            if (param != null) {
                data = new SecurityScenarioData();
                data.setPolicyRegistryPath((String)param.getValue());
                data.setScenarioId("policyFromRegistry");
            } else {
                SecurityScenario scenario = this.readCurrentScenario(serviceName);
                if (scenario != null) {
                    data = new SecurityScenarioData();
                    data.setCategory(scenario.getCategory());
                    data.setDescription(scenario.getDescription());
                    data.setScenarioId(scenario.getScenarioId());
                    data.setSummary(scenario.getSummary());
                }
            }
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            return data;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading persisted data", (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException("readingSecurity");
        }
    }

    public String[] getRequiredModules(String serviceName, String moduleId) throws Exception {
        SecurityScenarioData securityScenarioData = this.getCurrentScenario(serviceName);
        if (securityScenarioData != null) {
            SecurityScenario securityScenario = SecurityScenarioDatabase.get(securityScenarioData.getScenarioId());
            String[] moduleNames = securityScenario.modules.toArray(new String[securityScenario.modules.size()]);
            return moduleNames;
        }
        return null;
    }

    public void disableSecurityOnService(String serviceName) throws SecurityConfigException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)service);
        try {
            Policy policy;
            String[] moduleNames;
            String registrySecPolicyPath;
            if (service == null) {
                throw new SecurityConfigException("AxisService is Null");
            }
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
            boolean transactionStarted1 = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!transactionStarted1) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            String policyElementPath = serviceXPath + "/" + "policies" + "/" + "policy";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing " + policyElementPath));
            }
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, policyElementPath)) {
                if (!transactionStarted1) {
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                }
                return;
            }
            SecurityScenario scenario = this.readCurrentScenario(serviceName);
            if (scenario == null) {
                if (!transactionStarted1) {
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                }
                return;
            }
            String secPolicyPath = policyElementPath + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)scenario.getWsuId());
            if (this.serviceGroupFilePM.elementExists(serviceGroupId, secPolicyPath)) {
                this.serviceGroupFilePM.delete(serviceGroupId, secPolicyPath);
            }
            if (isProxyService && this.registry.resourceExists(registrySecPolicyPath = PersistenceUtils.getRegistryResourcePath((AxisService)service) + "/policies/" + scenario.getWsuId())) {
                this.registry.delete(registrySecPolicyPath);
            }
            for (String moduleName : moduleNames = scenario.getModules().toArray(new String[scenario.getModules().size()])) {
                AxisModule module = service.getAxisConfiguration().getModule(moduleName);
                service.disengageModule(module);
                String version = "undefined";
                if (module.getVersion() != null) {
                    version = module.getVersion().toString();
                }
                String modPath = serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)module.getName()) + PersistenceUtils.getXPathAttrPredicate((String)"version", (String)version) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules");
                this.serviceGroupFilePM.delete(serviceGroupId, modPath);
            }
            if (!transactionStarted1) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            this.registry.commitTransaction();
            SecurityServiceAdmin admin = new SecurityServiceAdmin(this.axisConfig, this.registry);
            admin.removeSecurityPolicyFromAllBindings(service, scenario.getWsuId());
            String scenarioId = scenario.getScenarioId();
            String resourceUri = "/repository/components/org.wso2.carbon.security.mgt/policy/" + scenarioId;
            try {
                String paramXPath;
                boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
                if (!transactionStarted) {
                    this.serviceGroupFilePM.beginTransaction(serviceGroupId);
                }
                this.serviceGroupFilePM.delete(serviceGroupId, serviceXPath + "/" + "association" + PersistenceUtils.getXPathAttrPredicate((String)"destinationPath", (String)resourceUri));
                AuthorizationManager acAdmin = this.realm.getAuthorizationManager();
                String resourceName = serviceGroupId + "/" + serviceName;
                String[] roles = acAdmin.getAllowedRolesForResource(resourceName, "invoke-service");
                for (int i = 0; i < roles.length; ++i) {
                    acAdmin.clearRoleAuthorization(roles[i], resourceName, "invoke-service");
                }
                List kss = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "service-keystore");
                for (Object ks : kss) {
                    ((OMNode)ks).detach();
                }
                List tkss = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "trusted-keystore");
                for (Object tks : tkss) {
                    ((OMNode)tks).detach();
                }
                if (roles == null || roles.length == 0 || kss == null || kss.isEmpty() || tkss == null || tkss.isEmpty()) {
                    this.serviceGroupFilePM.setMetaFileModification(serviceGroupId);
                }
                if (this.serviceGroupFilePM.elementExists(serviceGroupId, paramXPath = serviceXPath + "/" + "parameter" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)"secPolicyRegistryPath"))) {
                    this.serviceGroupFilePM.delete(serviceGroupId, paramXPath);
                    this.serviceGroupFilePM.setMetaFileModification(serviceGroupId);
                }
                if (!transactionStarted) {
                    this.serviceGroupFilePM.commitTransaction(serviceGroupId);
                }
            }
            catch (Exception e) {
                String msg = "Unable to remove persisted data.";
                log.error((Object)msg);
                this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                throw new AxisFault(msg, (Throwable)e);
            }
            Parameter param = new Parameter();
            param.setName("passwordCallbackRef");
            service.removeParameter(param);
            Parameter param2 = new Parameter();
            param2.setName("disableREST");
            service.removeParameter(param2);
            Parameter pathParam = service.getParameter("secPolicyRegistryPath");
            String policyPath = null;
            if (pathParam != null) {
                policyPath = (String)pathParam.getValue();
                service.removeParameter(pathParam);
            }
            if (this.isHttpsTransportOnly(policy = this.loadPolicy(scenarioId, policyPath))) {
                try {
                    boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
                    if (!transactionStarted) {
                        this.serviceGroupFilePM.beginTransaction(serviceGroupId);
                    }
                    this.persistenceFactory.getServicePM().deleteServiceProperty(service, "utEnabled");
                    List<String> transports = this.getAllTransports();
                    this.setServiceTransports(serviceName, transports);
                    AxisEvent event = new AxisEvent(100, (AxisDescription)service);
                    this.axisConfig.notifyObservers(event, service);
                    this.persistenceFactory.getServicePM().setServiceProperty(service, "exposedAllTransports", Boolean.TRUE.toString());
                    for (String trans : transports) {
                        if (trans.endsWith("https")) continue;
                        String transPath = "/repository/transports/" + trans;
                        if (this.registry.resourceExists(transPath)) {
                            this.persistenceFactory.getServicePM().updateServiceAssociation(service, transPath, "exposedTransports");
                            continue;
                        }
                        String msg = "Transport path " + transPath + " does not exist in the registry";
                        log.error((Object)msg);
                        this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                        throw new AxisFault(msg);
                    }
                    if (!transactionStarted) {
                        this.serviceGroupFilePM.commitTransaction(serviceGroupId);
                    }
                }
                catch (Exception e) {
                    String msg = "Service with name " + serviceName + " not found.";
                    log.error((Object)msg);
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                    throw new AxisFault(msg, (Throwable)e);
                }
            }
            if (service.getFileName() != null) {
                this.updateSecScenarioInGhostFile(service.getFileName().getPath(), serviceName, null);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
        }
        catch (SecurityConfigException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException("removingPolicy", e);
        }
    }

    private KerberosConfigData readKerberosConfigurations(AxisService service) throws SecurityConfigException {
        String kerberosXPath = this.getKerberosConfigXPath(service);
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            boolean isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, kerberosXPath)) {
                if (!isTransactionStarted) {
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                }
                return null;
            }
            OMElement kerberosElement = (OMElement)this.serviceGroupFilePM.get(serviceGroupId, kerberosXPath);
            KerberosConfigData kerberosConfigData = new KerberosConfigData();
            kerberosConfigData.setServicePrincipleName(kerberosElement.getAttributeValue(new QName("service.principal.name")));
            String encryptedString = kerberosElement.getAttributeValue(new QName("service.principal.password"));
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            try {
                kerberosConfigData.setServicePrinciplePassword(new String(cryptoUtil.base64DecodeAndDecrypt(encryptedString)));
            }
            catch (CryptoException e) {
                String msg = "Unable to decode and decrypt password string.";
                log.warn((Object)msg, (Throwable)e);
            }
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            return kerberosConfigData;
        }
        catch (PersistenceException e) {
            String msg = "An error occurred while retrieving kerberos configuration data for service " + service.getName();
            log.error((Object)msg, (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException(msg);
        }
    }

    private String getKerberosConfigXPath(AxisService service) {
        return PersistenceUtils.getResourcePath((AxisService)service) + "/" + RampartConfigUtil.KERBEROS_CONFIG_RESOURCE;
    }

    protected void persistsKerberosData(AxisService service, KerberosConfigData kerberosConfigData) throws SecurityConfigException {
        String kerberosXPath = this.getKerberosConfigXPath(service);
        ServiceGroupFilePersistenceManager sfpm = this.persistenceFactory.getServiceGroupFilePM();
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            boolean isTransactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            if (sfpm.elementExists(serviceGroupId, kerberosXPath)) {
                sfpm.delete(serviceGroupId, kerberosXPath);
            }
            OMElement kerberosElement = OMAbstractFactory.getOMFactory().createOMElement(RampartConfigUtil.KERBEROS_CONFIG_RESOURCE, null);
            kerberosElement.addAttribute("service.principal.name", kerberosConfigData.getServicePrincipleName(), null);
            kerberosElement.addAttribute("service.principal.password", this.getEncryptedPassword(kerberosConfigData.getServicePrinciplePassword()), null);
            sfpm.put(serviceGroupId, kerberosElement, PersistenceUtils.getResourcePath((AxisService)service));
            if (!isTransactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)"Error adding kerberos parameters to registry.", (Throwable)e);
            sfpm.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException("Unable to add kerberos parameters to registry.", e);
        }
    }

    private String getEncryptedPassword(String password) throws SecurityConfigException {
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        try {
            return cryptoUtil.encryptAndBase64Encode(password.getBytes());
        }
        catch (CryptoException e) {
            String msg = "Unable to encrypt and encode password string.";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    private String getRegistryServicePath(AxisService service) {
        return "/repository/axis2/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + service.getName();
    }

    public void activateUsernameTokenAuthentication(String serviceName, String[] userGroups) throws SecurityConfigException {
    }

    public void applySecurity(String serviceName, String scenarioId, KerberosConfigData kerberosConfigurations) throws SecurityConfigException {
        if (kerberosConfigurations == null) {
            log.error((Object)"Kerberos configurations provided are invalid.");
            throw new SecurityConfigException("Kerberos configuration parameters are null. Please specify valid kerberos configurations.");
        }
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            throw new SecurityConfigException("nullService");
        }
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            this.disableSecurityOnService(serviceName);
            boolean isRahasEngaged = false;
            this.applyPolicy(service, scenarioId, null, null, null, kerberosConfigurations);
            isRahasEngaged = this.engageModules(scenarioId, serviceName, service);
            if (!isRahasEngaged) {
                log.info((Object)("Rahas engaged to service - " + serviceName));
            }
            this.disableRESTCalls(serviceName, scenarioId);
            this.persistsKerberosData(service, kerberosConfigurations);
            if (!transactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
        }
        catch (PersistenceException e) {
            StringBuilder str = new StringBuilder("Error persisting security scenario ").append(scenarioId).append(" for service ").append(serviceName);
            log.error((Object)str.toString(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException(str.toString(), e);
        }
    }

    public void applySecurity(String serviceName, String scenrioId, String policyPath, String[] trustedStores, String privateStore, String[] userGroups) throws SecurityConfigException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            throw new SecurityConfigException("nullService");
        }
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            boolean registryTransactionStarted;
            boolean transactionStarted;
            if (userGroups != null) {
                Arrays.sort((Object[])userGroups);
                if (Arrays.binarySearch((Object[])userGroups, (Object)"wso2.anonymous.role") > -1) {
                    log.error((Object)"Security breach. A user is attempting to enable annonymous for UT access");
                    throw new SecurityConfigException("Invalid data provided");
                }
            }
            if (!(transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId))) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (!(registryTransactionStarted = Transaction.isStarted())) {
                this.registry.beginTransaction();
            }
            this.disableSecurityOnService(serviceName);
            if (GhostDeployerUtils.isGhostService((AxisService)service)) {
                try {
                    service = GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)service);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error while loading actual service from Ghost", (Throwable)axisFault);
                }
            }
            boolean isRahasEngaged = false;
            this.applyPolicy(service, scenrioId, policyPath, trustedStores, privateStore);
            isRahasEngaged = this.engageModules(scenrioId, serviceName, service);
            this.disableRESTCalls(serviceName, scenrioId);
            this.persistData(service, scenrioId, privateStore, trustedStores, userGroups, isRahasEngaged);
            if (!transactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            if (!registryTransactionStarted) {
                this.registry.commitTransaction();
            }
            if (service.getFileName() != null) {
                this.updateSecScenarioInGhostFile(service.getFileName().getPath(), serviceName, scenrioId);
            }
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            try {
                this.registry.rollbackTransaction();
            }
            catch (RegistryException ex) {
                log.error((Object)"Error while rollback", (Throwable)ex);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            try {
                this.registry.rollbackTransaction();
            }
            catch (RegistryException ex) {
                log.error((Object)"Error while rollback", (Throwable)ex);
            }
        }
    }

    protected void applyPolicy(AxisService service, String scenarioId, String policyPath, String[] trustedStores, String privateStore) throws SecurityConfigException {
        this.applyPolicy(service, scenarioId, policyPath, trustedStores, privateStore, null);
    }

    /*
     * Unable to fully structure code
     */
    protected void applyPolicy(AxisService service, String scenarioId, String policyPath, String[] trustedStores, String privateStore, KerberosConfigData kerberosConfig) throws SecurityConfigException {
        serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            registryServicePath = this.getRegistryServicePath(service);
            serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
            handler = null;
            handler = this.callback == null ? new ServicePasswordCallbackHandler(this.persistenceFactory, serviceGroupId, service.getName(), serviceXPath, registryServicePath, this.registry, this.realm) : this.callback;
            param = new Parameter();
            param.setName("passwordCallbackRef");
            param.setValue((Object)handler);
            service.addParameter(param);
            props = this.getServerCryptoProperties(privateStore, trustedStores);
            rampartConfig = new RampartConfig();
            this.populateRampartConfig(rampartConfig, props, kerberosConfig);
            policy = this.loadPolicy(scenarioId, policyPath);
            if (rampartConfig != null) {
                policy.addAssertion((Assertion)rampartConfig);
            }
            if (policyPath != null && scenarioId.equals("policyFromRegistry")) {
                pathParam = new Parameter("secPolicyRegistryPath", (Object)policyPath);
                pathParam.setLocked(true);
                service.addParameter(pathParam);
                this.persistenceFactory.getServicePM().updateServiceParameter(service, pathParam);
            }
            if (this.isHttpsTransportOnly(policy)) {
                this.setServiceTransports(service.getName(), this.getHttpsTransports());
                try {
                    transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
                    if (!transactionStarted) {
                        this.serviceGroupFilePM.beginTransaction(serviceGroupId);
                    }
                    this.serviceGroupFilePM.put(serviceGroupId, OMAbstractFactory.getOMFactory().createOMAttribute("utEnabled", null, Boolean.TRUE.toString()), serviceXPath);
                    this.serviceGroupFilePM.put(serviceGroupId, OMAbstractFactory.getOMFactory().createOMAttribute("exposedAllTransports", null, Boolean.FALSE.toString()), serviceXPath);
                    exposedTransports = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "exposedTransports");
                    isExists = false;
                    for (E node : exposedTransports) {
                        assoc = (OMElement)node;
                        transport = assoc.getAttributeValue(new QName("destinationPath"));
                        if (transport.endsWith("https")) {
                            isExists = true;
                            continue;
                        }
                        if (this.registry.resourceExists(transport)) {
                            assoc.detach();
                            this.serviceGroupFilePM.setMetaFileModification(serviceGroupId);
                            continue;
                        }
                        msg = "Transport resource " + transport + " not available in Registry";
                        SecurityConfigAdmin.log.error((Object)msg);
                        throw new AxisFault(msg);
                    }
                    if (!isExists) {
                        transportResourcePath = "/repository/transports/https/listener";
                        if (this.registry.resourceExists(transportResourcePath)) {
                            this.serviceGroupFilePM.put(serviceGroupId, PersistenceUtils.createAssociation((String)transportResourcePath, (String)"exposedTransports"), serviceXPath);
                        } else {
                            msg = "Transport resource " + transportResourcePath + " not available in Registry";
                            SecurityConfigAdmin.log.error((Object)msg);
                            throw new AxisFault(msg);
                        }
                    }
                    if (transactionStarted) ** GOTO lbl63
                    this.serviceGroupFilePM.commitTransaction(serviceGroupId);
                }
                catch (Exception e) {
                    msg = "Service with name " + service.getName() + " not found.";
                    SecurityConfigAdmin.log.error((Object)msg);
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                    throw new AxisFault(msg, (Throwable)e);
                }
            } else {
                this.setServiceTransports(service.getName(), this.getAllTransports());
            }
lbl63:
            // 3 sources

            secAdmin = new SecurityServiceAdmin(this.axisConfig, this.registry);
            secAdmin.addSecurityPolicyToAllBindings(service, policy);
        }
        catch (ServerException e) {
            SecurityConfigAdmin.log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException(e.getMessage(), e);
        }
        catch (Exception e) {
            SecurityConfigAdmin.log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException(e.getMessage(), e);
        }
    }

    protected boolean engageModules(String scenarioId, String serviceName, AxisService axisService) throws SecurityConfigException {
        boolean isRahasEngaged = false;
        SecurityScenario securityScenario = SecurityScenarioDatabase.get(scenarioId);
        String[] moduleNames = securityScenario.modules.toArray(new String[securityScenario.modules.size()]);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        try {
            try {
                boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
                if (!transactionStarted) {
                    this.serviceGroupFilePM.beginTransaction(serviceGroupId);
                }
                List assocs = this.serviceGroupFilePM.getAll(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
                for (String modName : moduleNames) {
                    String modulePath;
                    AxisModule module = axisService.getAxisConfiguration().getModule(modName);
                    boolean isFound = false;
                    for (Object node : assocs) {
                        OMElement tempAssoc = (OMElement)node;
                        String tempModeName = tempAssoc.getAttributeValue(new QName("name"));
                        String tempModeVersion = tempAssoc.getAttributeValue(new QName("version"));
                        if (!modName.equals(tempModeName) || !module.getVersion().toString().equals(tempModeVersion)) continue;
                        isFound = true;
                        break;
                    }
                    if (!isFound && this.moduleFilePM.elementExists(modName, modulePath = "/version" + PersistenceUtils.getXPathAttrPredicate((String)"id", (String)module.getVersion().toString()))) {
                        OMElement moduleElement = OMAbstractFactory.getOMFactory().createOMElement("module", null);
                        moduleElement.addAttribute("name", module.getName(), null);
                        if (module.getVersion() != null) {
                            moduleElement.addAttribute("version", module.getVersion().toString(), null);
                        }
                        moduleElement.addAttribute("type", "engagedModules", null);
                        this.serviceGroupFilePM.put(serviceGroupId, moduleElement, serviceXPath);
                    }
                    axisService.disengageModule(module);
                    axisService.engageModule(module);
                    if (!modName.equalsIgnoreCase("rahas")) continue;
                    isRahasEngaged = true;
                }
                if (!transactionStarted) {
                    this.serviceGroupFilePM.commitTransaction(serviceGroupId);
                }
            }
            catch (PersistenceException e) {
                this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                String msg = "Unable to engage modules.";
                log.error((Object)msg);
                throw new AxisFault(msg, (Throwable)e);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException(e.getMessage(), e);
        }
        return isRahasEngaged;
    }

    protected void disableRESTCalls(String serviceName, String scenrioId) throws SecurityConfigException {
        if (scenrioId.equals("scenario1")) {
            return;
        }
        try {
            AxisService service = this.axisConfig.getServiceForActivation(serviceName);
            if (service == null) {
                throw new SecurityConfigException("nullService");
            }
            Parameter param = new Parameter();
            param.setName("disableREST");
            param.setValue((Object)Boolean.TRUE.toString());
            service.addParameter(param);
        }
        catch (AxisFault e) {
            log.error((Object)e);
            throw new SecurityConfigException("disablingREST", e);
        }
    }

    protected void persistData(AxisService service, String scenrioId, String privateStore, String[] trustedStores, String[] userGroups, boolean isRahasEngaged) throws SecurityConfigException {
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
            boolean isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (privateStore != null) {
                OMElement assoc;
                String ksPath = "/repository/security/key-stores/" + privateStore;
                if (this.govRegistry.resourceExists(ksPath)) {
                    assoc = PersistenceUtils.createAssociation((String)("/_system/governance" + ksPath), (String)"service-keystore");
                    this.serviceGroupFilePM.put(serviceGroupId, assoc, serviceXPath);
                } else if (KeyStoreUtil.isPrimaryStore((String)privateStore)) {
                    assoc = PersistenceUtils.createAssociation((String)"/_system/governance/repository/security/key-stores/carbon-primary-ks", (String)"service-keystore");
                    this.serviceGroupFilePM.put(serviceGroupId, assoc, serviceXPath);
                } else {
                    throw new SecurityConfigException("Missing key store " + privateStore);
                }
            }
            if (trustedStores != null) {
                for (String storeName : trustedStores) {
                    OMElement assoc;
                    String ksPath = "/repository/security/key-stores/" + storeName;
                    if (this.govRegistry.resourceExists(ksPath)) {
                        assoc = PersistenceUtils.createAssociation((String)("/_system/governance" + ksPath), (String)"trusted-keystore");
                        this.serviceGroupFilePM.put(serviceGroupId, assoc, serviceXPath);
                        continue;
                    }
                    if (KeyStoreUtil.isPrimaryStore((String)storeName)) {
                        assoc = PersistenceUtils.createAssociation((String)"/_system/governance/repository/security/key-stores/carbon-primary-ks", (String)"trusted-keystore");
                        this.serviceGroupFilePM.put(serviceGroupId, assoc, serviceXPath);
                        continue;
                    }
                    throw new SecurityConfigException("Missing key store" + storeName);
                }
            }
            if (userGroups != null) {
                for (String value : userGroups) {
                    AuthorizationManager acAdmin = this.realm.getAuthorizationManager();
                    acAdmin.authorizeRole(value, serviceGroupId + "/" + service.getName(), "invoke-service");
                }
            }
            if (isRahasEngaged) {
                this.setRahasParameters(service, privateStore);
            } else {
                this.removeRahasParameters(service);
            }
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException(e.getMessage(), e);
        }
    }

    public Policy loadPolicy(String scenarioId, String policyPath) throws SecurityConfigException {
        try {
            OMAttribute att;
            Registry registryToLoad = this.registry;
            String resourceUri = "/repository/components/org.wso2.carbon.security.mgt/policy/" + scenarioId;
            if (policyPath != null && scenarioId.equals("policyFromRegistry")) {
                resourceUri = policyPath.substring(policyPath.lastIndexOf(58) + 1);
                String regIdentifier = policyPath.substring(0, policyPath.lastIndexOf(58));
                if ("gov".equals(regIdentifier)) {
                    registryToLoad = this.govRegistry;
                }
            }
            Resource resource = registryToLoad.get(resourceUri);
            InputStream in = resource.getContentStream();
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement policyElement = builder.getDocumentElement();
            if (policyPath != null && scenarioId.equals("policyFromRegistry") && (att = policyElement.getAttribute(SecurityConstants.POLICY_ID_QNAME)) != null) {
                att.setAttributeValue("policyFromRegistry");
            }
            return PolicyEngine.getPolicy((OMElement)policyElement);
        }
        catch (Exception e) {
            log.error((Object)"loadingPolicy", (Throwable)e);
            throw new SecurityConfigException("loadingPolicy", e);
        }
    }

    public void populateRampartConfig(RampartConfig rampartConfig, Properties props) throws SecurityConfigException {
        this.populateRampartConfig(rampartConfig, props, null);
    }

    public void populateRampartConfig(RampartConfig rampartConfig, Properties props, KerberosConfigData kerberosConfigurations) throws SecurityConfigException {
        if (rampartConfig != null) {
            if (kerberosConfigurations != null) {
                String krbFile;
                Properties kerberosProperties = new Properties();
                kerberosProperties.setProperty("service.principal.name", kerberosConfigurations.getServicePrincipleName());
                KerberosConfig kerberosConfig = new KerberosConfig();
                kerberosConfig.setProp(kerberosProperties);
                String carbonSecurityConfigurationPath = RampartConfigUtil.getCarbonSecurityConfigurationPath();
                if (carbonSecurityConfigurationPath != null) {
                    krbFile = carbonSecurityConfigurationPath + File.separatorChar + KerberosConfigData.KERBEROS_CONFIG_FILE_NAME;
                    File krbFileObject = new File(krbFile);
                    if (!krbFileObject.exists()) {
                        throw new SecurityConfigException("Kerberos configuration file not found at " + krbFile);
                    }
                } else {
                    throw new SecurityConfigException("Could not retrieve carbon home");
                }
                log.info((Object)("Setting " + KerberosConfigData.KERBEROS_CONFIG_FILE_SYSTEM_PROPERTY + " to kerberos configuration file " + krbFile));
                System.setProperty(KerberosConfigData.KERBEROS_CONFIG_FILE_SYSTEM_PROPERTY, krbFile);
                rampartConfig.setKerberosConfig(kerberosConfig);
            } else {
                if (!props.isEmpty()) {
                    CryptoConfig encrCryptoConfig = new CryptoConfig();
                    encrCryptoConfig.setProvider(ServerCrypto.class.getName());
                    encrCryptoConfig.setProp(props);
                    encrCryptoConfig.setCacheEnabled(true);
                    encrCryptoConfig.setCryptoKey("org.wso2.carbon.security.crypto.privatestore");
                    rampartConfig.setEncrCryptoConfig(encrCryptoConfig);
                    CryptoConfig signatureCryptoConfig = new CryptoConfig();
                    signatureCryptoConfig.setProvider(ServerCrypto.class.getName());
                    signatureCryptoConfig.setProp(props);
                    signatureCryptoConfig.setCacheEnabled(true);
                    signatureCryptoConfig.setCryptoKey("org.wso2.carbon.security.crypto.privatestore");
                    rampartConfig.setSigCryptoConfig(signatureCryptoConfig);
                }
                rampartConfig.setEncryptionUser("useReqSigCert");
                rampartConfig.setUser(props.getProperty(USER));
                int ttl = 300;
                int timeSkew = 300;
                rampartConfig.setTimestampTTL(Integer.toString(ttl));
                rampartConfig.setTimestampMaxSkew(Integer.toString(timeSkew));
                rampartConfig.setTokenStoreClass(SecurityTokenStore.class.getName());
            }
        }
    }

    public Properties getServerCryptoProperties(String privateStore, String[] trustedCertStores) throws Exception {
        Properties props = new Properties();
        int tenantId = ((UserRegistry)this.registry).getTenantId();
        UserRegistry govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
        if (trustedCertStores != null && trustedCertStores.length > 0) {
            StringBuilder trstString = new StringBuilder();
            for (int i = 0; i < trustedCertStores.length; ++i) {
                trstString.append(trustedCertStores[i]).append(",");
            }
            if (trustedCertStores.length != 0) {
                props.setProperty("org.wso2.carbon.security.crypto.truststores", trstString.toString());
            }
        }
        if (privateStore != null) {
            props.setProperty("org.wso2.carbon.security.crypto.privatestore", privateStore);
            KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantId);
            KeyStore ks = keyMan.getKeyStore(privateStore);
            String privKeyAlias = KeyStoreUtil.getPrivateKeyAlias((KeyStore)ks);
            props.setProperty("org.wso2.carbon.security.crypto.alias", privKeyAlias);
            props.setProperty(USER, privKeyAlias);
        }
        if (privateStore != null || trustedCertStores != null && trustedCertStores.length > 0) {
            props.setProperty("org.wso2.stratos.tenant.id", new Integer(tenantId).toString());
        }
        return props;
    }

    public void setServiceTransports(String serviceId, List<String> transportProtocols) throws SecurityConfigException, AxisFault {
        AxisService axisService = this.axisConfig.getServiceForActivation(serviceId);
        if (axisService == null) {
            throw new SecurityConfigException("nullService");
        }
        ArrayList<String> transports = new ArrayList<String>();
        for (int i = 0; i < transportProtocols.size(); ++i) {
            transports.add(transportProtocols.get(i));
        }
        axisService.setExposedTransports(transports);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully add selected transport bindings to service " + serviceId));
        }
    }

    public boolean isHttpsTransportOnly(Policy policy) throws SecurityConfigException {
        boolean httpsRequired = false;
        try {
            Iterator alternatives = policy.getAlternatives();
            if (alternatives.hasNext()) {
                Token encrToken;
                List it = (List)alternatives.next();
                RampartPolicyData rampartPolicyData = RampartPolicyBuilder.build((List)it);
                if (rampartPolicyData.isTransportBinding()) {
                    httpsRequired = true;
                } else if (rampartPolicyData.isSymmetricBinding() && (encrToken = rampartPolicyData.getEncryptionToken()) instanceof SecureConversationToken) {
                    Policy bsPol = ((SecureConversationToken)encrToken).getBootstrapPolicy();
                    Iterator alts = bsPol.getAlternatives();
                    if (alts.hasNext()) {
                        // empty if block
                    }
                    List bsIt = (List)alts.next();
                    RampartPolicyData bsRampartPolicyData = RampartPolicyBuilder.build((List)bsIt);
                    httpsRequired = bsRampartPolicyData.isTransportBinding();
                }
            }
        }
        catch (WSSPolicyException e) {
            log.error((Object)e);
            throw new SecurityConfigException(e.getMessage(), e);
        }
        return httpsRequired;
    }

    public List<String> getHttpsTransports() {
        ArrayList<String> httpsTransports = new ArrayList<String>();
        for (String transport : this.axisConfig.getTransportsIn().keySet()) {
            if (transport.toLowerCase().indexOf("https") == -1) continue;
            httpsTransports.add(transport);
        }
        return httpsTransports;
    }

    public List<String> getAllTransports() {
        ArrayList<String> allTransports = new ArrayList<String>();
        for (String transport : this.axisConfig.getTransportsIn().keySet()) {
            allTransports.add(transport);
        }
        return allTransports;
    }

    public SecurityConfigData getSecurityConfigData(String serviceName, String scenarioId, String policyPath) throws SecurityConfigException {
        SecurityConfigData data = null;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            SecurityScenario scenario;
            Parameter param;
            if (scenarioId == null) {
                return data;
            }
            if (scenarioId.equals("policyFromRegistry") ? (param = service.getParameter("secPolicyRegistryPath")) == null || !policyPath.equals(param.getValue()) : (scenario = this.readCurrentScenario(serviceName)) == null || !scenario.getScenarioId().equals(scenarioId)) {
                return data;
            }
            boolean isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            data = new SecurityConfigData();
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
            AuthorizationManager acReader = this.realm.getAuthorizationManager();
            String[] roles = acReader.getAllowedRolesForResource(serviceGroupId + "/" + serviceName, "invoke-service");
            data.setUserGroups(roles);
            List pvtStores = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "service-keystore");
            if (pvtStores.size() > 0) {
                String temp = ((OMElement)pvtStores.get(0)).getAttributeValue(new QName("destinationPath"));
                if (temp.startsWith("//")) {
                    temp = temp.substring(1);
                }
                if (temp.equals("/_system/governance/repository/security/key-stores/carbon-primary-ks")) {
                    ServerConfiguration config = ServerConfiguration.getInstance();
                    String file = new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath();
                    String name = KeyStoreUtil.getKeyStoreFileName((String)file);
                    data.setPrivateStore(name);
                } else {
                    temp = temp.substring(temp.lastIndexOf("/") + 1);
                    data.setPrivateStore(temp);
                }
            }
            List tstedStores = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "trusted-keystore");
            String[] trustedStores = new String[tstedStores.size()];
            for (int i = 0; i < tstedStores.size(); ++i) {
                String temp = ((OMElement)tstedStores.get(0)).getAttributeValue(new QName("destinationPath"));
                if (temp.startsWith("//")) {
                    temp = temp.substring(1);
                }
                if (temp.equals("/_system/governance/repository/security/key-stores/carbon-primary-ks")) {
                    String name;
                    ServerConfiguration config = ServerConfiguration.getInstance();
                    String file = new File(config.getFirstProperty("Security.KeyStore.Location")).getAbsolutePath();
                    trustedStores[i] = name = KeyStoreUtil.getKeyStoreFileName((String)file);
                    continue;
                }
                trustedStores[i] = temp = temp.substring(temp.lastIndexOf("/") + 1);
            }
            data.setTrustedKeyStores(trustedStores);
            KerberosConfigData kerberosData = this.readKerberosConfigurations(service);
            data.setKerberosConfigurations(kerberosData);
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            return data;
        }
        catch (PersistenceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
        }
        return data;
    }

    public SecurityScenario readCurrentScenario(String serviceName) throws SecurityConfigException {
        SecurityScenario scenario = null;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String serviceGroupId = null;
        try {
            String servicePath;
            String policyElementPath;
            boolean isTransactionStarted;
            if (service == null) {
                try {
                    service = (AxisService)GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.axisConfig).get(serviceName);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error while reading Transit Ghosts map", (Throwable)axisFault);
                }
                if (service == null) {
                    throw new SecurityConfigException("AxisService is Null" + service);
                }
            }
            if (!(isTransactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId = service.getAxisServiceGroup().getServiceGroupName()))) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, policyElementPath = (servicePath = PersistenceUtils.getResourcePath((AxisService)service)) + "/" + "policies" + "/" + "policy")) {
                if (!isTransactionStarted) {
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                }
                return scenario;
            }
            List policyElements = this.serviceGroupFilePM.getAll(serviceGroupId, policyElementPath);
            if (policyElements.size() == 0) {
                if (!isTransactionStarted) {
                    this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
                }
                return scenario;
            }
            if (!isTransactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            if (GhostDeployerUtils.isGhostService((AxisService)service)) {
                service = GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)service);
            }
            Map endPointMap = service.getEndpoints();
            for (Map.Entry o : endPointMap.entrySet()) {
                scenario = null;
                Map.Entry entry = o;
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                Collection policies = binding.getPolicySubject().getAttachedPolicyComponents();
                Iterator policyComponents = policies.iterator();
                String policyId = "";
                while (policyComponents.hasNext()) {
                    PolicyComponent currentPolicyComponent = (PolicyComponent)policyComponents.next();
                    if (currentPolicyComponent instanceof Policy) {
                        policyId = ((Policy)currentPolicyComponent).getId();
                    } else if (currentPolicyComponent instanceof PolicyReference) {
                        policyId = ((PolicyReference)currentPolicyComponent).getURI().substring(1);
                    }
                    scenario = SecurityScenarioDatabase.getByWsuId(policyId);
                }
                if (scenario != null || binding.getName().getLocalPart().contains("HttpBinding")) continue;
                break;
            }
            if (scenario == null) {
                Collection policies = service.getPolicySubject().getAttachedPolicyComponents();
                Iterator policyComponents = policies.iterator();
                String policyId = "";
                while (policyComponents.hasNext()) {
                    PolicyComponent currentPolicyComponent = (PolicyComponent)policyComponents.next();
                    if (currentPolicyComponent instanceof Policy) {
                        policyId = ((Policy)currentPolicyComponent).getId();
                    } else if (currentPolicyComponent instanceof PolicyReference) {
                        policyId = ((PolicyReference)currentPolicyComponent).getURI().substring(1);
                    }
                    scenario = SecurityScenarioDatabase.getByWsuId(policyId);
                }
            }
            return scenario;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading Security Scenario", (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new SecurityConfigException("readingSecurity", e);
        }
    }

    public void forceActualServiceDeployment(String serviceName) {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            try {
                service = (AxisService)GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.axisConfig).get(serviceName);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while reading Transit Ghosts map", (Throwable)axisFault);
            }
        }
        if (service != null && GhostDeployerUtils.isGhostService((AxisService)service)) {
            try {
                GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)service);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while loading actual service from Ghost", (Throwable)axisFault);
            }
        }
    }

    private void setRahasParameters(AxisService axisService, String privateKeyStore) throws PersistenceException, AxisFault {
        Properties cryptoProps = new Properties();
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceName = axisService.getName();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        List pvtStores = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "service-keystore");
        List tstedStores = this.serviceGroupFilePM.getAssociations(serviceGroupId, serviceXPath, "trusted-keystore");
        if (pvtStores != null && pvtStores.size() > 0) {
            String keyAlias = null;
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            keyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
            cryptoProps.setProperty("org.wso2.carbon.security.crypto.privatestore", privateKeyStore);
            cryptoProps.setProperty("org.wso2.carbon.security.crypto.alias", keyAlias);
        }
        StringBuilder trustStores = new StringBuilder();
        for (Object node : tstedStores) {
            OMElement assoc = (OMElement)node;
            String tstedStore = assoc.getAttributeValue(new QName("destinationPath"));
            String name = tstedStore.substring(tstedStore.lastIndexOf("/"));
            trustStores.append(name).append(",");
        }
        cryptoProps.setProperty("org.wso2.carbon.security.crypto.truststores", trustStores.toString());
        try {
            this.setServiceParameterElement(serviceName, RahasUtil.getSCTIssuerConfigParameter(ServerCrypto.class.getName(), cryptoProps, -1, null, true, true));
            this.setServiceParameterElement(serviceName, RahasUtil.getTokenCancelerConfigParameter());
            OMElement serviceElement = (OMElement)this.serviceGroupFilePM.get(serviceGroupId, serviceXPath);
            serviceElement.addAttribute("rahas.sctissuer", Boolean.TRUE.toString(), null);
            this.serviceGroupFilePM.setMetaFileModification(serviceGroupId);
        }
        catch (Exception e) {
            throw new AxisFault("Could not configure Rahas parameters", (Throwable)e);
        }
    }

    private void persistParameter(String serviceGroupId, Parameter parameter, String serviceXPath) throws Exception {
        String paramName;
        boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
        if (!transactionStarted) {
            this.serviceGroupFilePM.beginTransaction(serviceGroupId);
        }
        if ((paramName = parameter.getName()) != null && paramName.trim().length() != 0) {
            if (parameter.getParameterElement() == null && parameter.getValue() != null && parameter.getValue() instanceof String) {
                parameter = ParameterUtil.createParameter((String)paramName.trim(), (String)((String)parameter.getValue()), (boolean)parameter.isLocked());
            }
            if (parameter.getParameterElement() != null) {
                OMElement paramElemenet = parameter.getParameterElement().cloneOMElement();
                if (paramElemenet.getAttribute(new QName("name")) == null) {
                    paramElemenet.addAttribute("name", parameter.getName(), null);
                }
                this.serviceGroupFilePM.put(serviceGroupId, paramElemenet, serviceXPath);
            }
        }
        if (!transactionStarted) {
            this.serviceGroupFilePM.commitTransaction(serviceGroupId);
        }
    }

    private void removeRahasParameters(AxisService axisService) throws AxisFault {
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        try {
            OMElement serviceElement;
            if (this.serviceGroupFilePM.elementExists(serviceGroupId, serviceXPath) && (serviceElement = (OMElement)this.serviceGroupFilePM.get(serviceGroupId, serviceXPath)).getAttribute(new QName("rahas.sctissuer")) != null) {
                serviceElement.removeAttribute(serviceElement.getAttribute(new QName("rahas.sctissuer")));
            }
        }
        catch (Exception e) {
            throw new AxisFault("Could not configure Rahas parameters", (Throwable)e);
        }
    }

    private void setServiceParameterElement(String serviceName, Parameter parameter) throws AxisFault {
        AxisService axisService = this.axisConfig.getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceName + "'");
        }
        Parameter p = axisService.getParameter(parameter.getName());
        if (p != null) {
            if (!p.isLocked()) {
                axisService.addParameter(parameter);
            }
        } else {
            axisService.addParameter(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecScenarioInGhostFile(String servicePath, String serviceName, String scenarioId) {
        File ghostFile = GhostDeployerUtils.getGhostFile((String)servicePath, (AxisConfiguration)this.axisConfig);
        if (ghostFile != null && ghostFile.exists()) {
            FileInputStream ghostInStream = null;
            FileOutputStream ghostOutStream = null;
            try {
                ghostInStream = new FileInputStream(ghostFile);
                OMElement ghostSGElement = new StAXOMBuilder((InputStream)ghostInStream).getDocumentElement();
                Iterator itr = ghostSGElement.getChildrenWithLocalName("service");
                while (itr.hasNext()) {
                    OMElement serviceElm = (OMElement)itr.next();
                    String nameFromFile = serviceElm.getAttributeValue(new QName("name"));
                    if (nameFromFile == null || !nameFromFile.equals(serviceName)) continue;
                    OMAttribute secAtt = serviceElm.getAttribute(new QName("securityScenario"));
                    if (scenarioId == null) {
                        if (secAtt != null) {
                            serviceElm.removeAttribute(secAtt);
                            continue;
                        }
                        return;
                    }
                    if (secAtt == null) {
                        serviceElm.addAttribute("securityScenario", scenarioId, null);
                        continue;
                    }
                    secAtt.setAttributeValue(scenarioId);
                }
                ghostOutStream = new FileOutputStream(ghostFile);
                ghostSGElement.serialize((OutputStream)ghostOutStream);
                ghostOutStream.flush();
            }
            catch (Exception e) {
                log.error((Object)("Error while reading ghost file for service : " + servicePath));
            }
            finally {
                try {
                    if (ghostInStream != null) {
                        ghostInStream.close();
                    }
                    if (ghostOutStream != null) {
                        ghostOutStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the file output stream", (Throwable)e);
                }
            }
        }
    }
}

