/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.wso2.xkms2.ElementSerializable;
import org.wso2.xkms2.KeyBindingAbstractType;
import org.wso2.xkms2.TimeInstant;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public class QueryKeyBinding
extends KeyBindingAbstractType
implements ElementSerializable {
    private TimeInstant timeInstance;

    public TimeInstant getTimeInstance() {
        return this.timeInstance;
    }

    public void setTimeInstance(TimeInstant timeInstance) {
        this.timeInstance = timeInstance;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        OMElement queryKeyBindingEle = factory.createOMElement(XKMS2Constants.ELE_QUERY_KEY_BINDING);
        super.serialize(factory, queryKeyBindingEle);
        if (this.timeInstance != null) {
            OMElement timeInstantEle = factory.createOMElement(XKMS2Constants.ELE_TIME_INSTANCE);
            String dateTime = this.timeInstance.getDateTime();
            if (dateTime == null) {
                throw new XKMSException("Time is not available");
            }
            OMNamespace emptyNs = factory.createOMNamespace("", "");
            timeInstantEle.addAttribute("Time", dateTime, emptyNs);
            queryKeyBindingEle.addChild((OMNode)timeInstantEle);
        }
        return queryKeyBindingEle;
    }
}

