/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.xkms2.KeyUsage;
import org.wso2.xkms2.UseKeyWith;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;

public abstract class KeyBindingAbstractType
implements XKMSElement {
    private String id;
    private KeyInfo keyInfo;
    private List keyUsagesList = new ArrayList(3);
    private List useKeyWithList = new ArrayList();
    private PublicKey keyValue;
    private X509Certificate certValue;
    private String keyName;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setKeyValue(PublicKey keyValue) {
        this.keyValue = keyValue;
    }

    public PublicKey getKeyValue() {
        return this.keyValue;
    }

    public void setCertValue(X509Certificate certValue) {
        this.certValue = certValue;
    }

    public X509Certificate getCertValue() {
        return this.certValue;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void addKeyUsage(KeyUsage keyUsage) {
        this.keyUsagesList.add(keyUsage);
    }

    public List getKeyUsage() {
        return this.keyUsagesList;
    }

    public void addUseKeyWith(String application, String identifier) {
        this.useKeyWithList.add(new UseKeyWith(application, identifier));
    }

    public void addUseKeyWith(UseKeyWith useKeyWith) {
        this.useKeyWithList.add(useKeyWith);
    }

    public List getUseKeyWith() {
        return this.useKeyWithList;
    }

    protected void serialize(OMFactory factory, OMElement container) throws XKMSException {
        if (this.keyInfo == null && (this.keyName != null || this.keyValue != null || this.certValue != null)) {
            Document doc = ((Element)container).getOwnerDocument();
            this.keyInfo = new KeyInfo(doc);
            if (this.keyName != null) {
                KeyName keyName = new KeyName(doc, this.keyName);
                this.keyInfo.add(keyName);
            }
            if (this.keyValue != null) {
                this.keyInfo.addKeyValue(this.keyValue);
            }
            if (this.certValue != null) {
                X509Data data = new X509Data(doc);
                try {
                    data.addCertificate(this.certValue);
                    this.keyInfo.add(data);
                }
                catch (XMLSecurityException ex) {
                    throw new XKMSException(ex);
                }
            }
            this.keyInfo.add(this.keyValue);
        }
        if (this.keyInfo != null) {
            Element kiElement = this.keyInfo.getElement();
            Element containerDOMElement = (Element)container;
            Document ownerDocument = containerDOMElement.getOwnerDocument();
            Node node = ownerDocument.importNode(kiElement, true);
            containerDOMElement.appendChild(node);
        }
        Iterator iterator = this.keyUsagesList.iterator();
        while (iterator.hasNext()) {
            KeyUsage keyUsage = (KeyUsage)iterator.next();
            OMElement keyUsageEle = factory.createOMElement(XKMS2Constants.ELE_KEY_USAGE);
            keyUsageEle.setText(keyUsage.getAnyURI());
            container.addChild((OMNode)keyUsageEle);
        }
        if (this.useKeyWithList != null) {
            iterator = this.useKeyWithList.iterator();
            while (iterator.hasNext()) {
                UseKeyWith useKeyWith = (UseKeyWith)iterator.next();
                container.addChild((OMNode)useKeyWith.serialize(factory));
            }
        }
        if (this.id != null) {
            OMNamespace emptyNs = factory.createOMNamespace("", "");
            container.addAttribute("Id", this.id, emptyNs);
        }
    }
}

