/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.util;

import java.io.IOException;
import java.security.KeyStore;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.util.RampartConfigUtil;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.TenantUtils;

public class ServicePasswordCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(ServicePasswordCallbackHandler.class);
    private String serviceGroupId = null;
    private String serviceId = null;
    private Registry registry = null;
    private UserRealm realm = null;
    private String serviceXPath = null;
    private String registryServicePath = null;
    private PersistenceFactory persistenceFactory;

    public ServicePasswordCallbackHandler(PersistenceFactory persistenceFactory, String serviceGroupId, String serviceId, String serviceXPath, String registryServicePath, Registry registry, UserRealm realm) throws RegistryException, SecurityConfigException {
        this.registry = registry;
        this.serviceId = serviceId;
        this.serviceGroupId = serviceGroupId;
        this.realm = realm;
        this.serviceXPath = serviceXPath;
        this.registryServicePath = registryServicePath;
        this.persistenceFactory = persistenceFactory;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
lbl1:
        // 2 sources

        try {
            for (i = 0; i < callbacks.length; ++i) {
                block14: {
                    if (!(callbacks[i] instanceof WSPasswordCallback)) break block14;
                    passwordCallback = (WSPasswordCallback)callbacks[i];
                    username = passwordCallback.getIdentifer();
                    receivedPasswd = null;
                    switch (passwordCallback.getUsage()) {
                        case 1: 
                        case 3: {
                            password = this.getPrivateKeyPassword(username);
                            if (password == null) {
                                throw new UnsupportedCallbackException(callbacks[i], "User not available in a trusted store");
                            }
                            passwordCallback.setPassword(password);
                            break;
                        }
                        case 9: {
                            passwordCallback.setPassword(this.getServicePrincipalPassword());
                            break;
                        }
                        case 5: {
                            receivedPasswd = passwordCallback.getPassword();
                            try {
                                if (receivedPasswd != null && this.authenticateUser(username, receivedPasswd)) ** GOTO lbl1
                                throw new UnsupportedCallbackException(callbacks[i], "check failed");
                            }
                            catch (Exception e) {
                                throw new UnsupportedCallbackException(callbacks[i], "Check failed : System error");
                            }
                        }
                        default: {
                            passwordCallback.setPassword(receivedPasswd);
                        }
                    }
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
        catch (UnsupportedCallbackException e) {
            if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                ServicePasswordCallbackHandler.log.debug((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            throw e;
        }
        catch (IOException e) {
            ServicePasswordCallbackHandler.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ServicePasswordCallbackHandler.log.error((Object)e.getMessage(), (Throwable)e);
            throw new UnsupportedCallbackException(null, e.getMessage());
        }
    }

    private String getServicePrincipalPassword() throws PersistenceException, SecurityConfigException {
        String kerberosPath = this.serviceXPath + "/" + RampartConfigUtil.KERBEROS_CONFIG_RESOURCE;
        String servicePrincipalPasswordResource = kerberosPath + "/@" + "service.principal.password";
        ServiceGroupFilePersistenceManager sfpm = this.persistenceFactory.getServiceGroupFilePM();
        if (!sfpm.elementExists(this.serviceGroupId, servicePrincipalPasswordResource)) {
            String msg = "Unable to find service principle password registry resource in path " + servicePrincipalPasswordResource;
            log.error((Object)msg);
            throw new SecurityConfigException(msg);
        }
        OMAttribute principalPassword = sfpm.getAttribute(this.serviceGroupId, servicePrincipalPasswordResource);
        if (principalPassword != null) {
            String password = principalPassword.getAttributeValue();
            if (password != null) {
                password = this.getDecryptedPassword(password);
                return password;
            }
            StringBuilder msg = new StringBuilder("Retrieved principal password is null in registry path ").append(servicePrincipalPasswordResource).append(" for property ").append("service.principal.password");
            log.error((Object)msg.toString());
            throw new SecurityConfigException(msg.toString());
        }
        StringBuilder msg = new StringBuilder("Retrieved principal resource is null in service metafile").append(servicePrincipalPasswordResource).append(" for property ").append("service.principal.password");
        log.error((Object)msg.toString());
        throw new SecurityConfigException(msg.toString());
    }

    private String getDecryptedPassword(String encryptedString) throws SecurityConfigException {
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        try {
            return new String(cryptoUtil.base64DecodeAndDecrypt(encryptedString));
        }
        catch (CryptoException e) {
            String msg = "Unable to decode and decrypt password string.";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    public boolean authenticateUser(String user, String password) throws Exception {
        boolean isAuthenticated = false;
        boolean isAuthorized = false;
        String tenantAwareUserName = TenantUtils.getTenantAwareUsername((String)user);
        try {
            UserRealm realm = AnonymousSessionUtil.getRealmByUserName((RegistryService)SecurityServiceHolder.getRegistryService(), (RealmService)SecurityServiceHolder.getRealmService(), (String)user);
            isAuthorized = realm.getAuthorizationManager().isUserAuthorized(tenantAwareUserName, this.serviceGroupId + "/" + this.serviceId, "invoke-service");
            if (isAuthorized) {
                isAuthenticated = realm.getUserStoreManager().authenticate(tenantAwareUserName, (Object)password);
            }
            return isAuthenticated;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String getPrivateKeyPassword(String username) throws IOException, Exception {
        String password;
        block6: {
            password = null;
            int tenantId = ((UserRegistry)this.registry).getTenantId();
            UserRegistry govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
            try {
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantId);
                if (!govRegistry.resourceExists("/repository/security/key-stores")) break block6;
                Collection collection = (Collection)govRegistry.get("/repository/security/key-stores");
                String[] ks = collection.getChildren();
                for (int i = 0; i < ks.length; ++i) {
                    String fullname = ks[i];
                    if (tenantId == -1234 && fullname.equals("/repository/security/key-stores/carbon-primary-ks")) {
                        KeyStore store = keyMan.getPrimaryKeyStore();
                        if (!store.containsAlias(username)) continue;
                        password = keyMan.getPrimaryPrivateKeyPasssword();
                    } else {
                        String name = fullname.substring(fullname.lastIndexOf("/") + 1);
                        KeyStore store = keyMan.getKeyStore(name);
                        if (!store.containsAlias(username)) continue;
                        Resource resource = govRegistry.get(ks[i]);
                        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
                        String encryptedPassword = resource.getProperty("privatekeyPass");
                        password = new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return password;
    }
}

