/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.ModuleFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.utils.ServerException;

public class SecurityServiceAdmin {
    protected AxisConfiguration axisConfig = null;
    private static Log log = LogFactory.getLog(SecurityServiceAdmin.class);
    private PersistenceFactory persistenceFactory;
    private ServiceGroupFilePersistenceManager serviceGroupFilePM;
    private ModuleFilePersistenceManager moduleFilePM;

    public SecurityServiceAdmin(AxisConfiguration config) throws ServerException {
        this.axisConfig = config;
        try {
            this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)config);
            this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
            this.moduleFilePM = this.persistenceFactory.getModuleFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error creating an PersistenceFactory instance", (Throwable)e);
            throw new ServerException("Error creating an PersistenceFactory instance", (Throwable)e);
        }
    }

    public SecurityServiceAdmin(AxisConfiguration config, Registry registry) {
        this.axisConfig = config;
        try {
            this.persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)config);
            this.serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
            this.moduleFilePM = this.persistenceFactory.getModuleFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error creating an PersistenceFactory instance", (Throwable)e);
        }
    }

    public void addSecurityPolicyToAllBindings(AxisService axisService, Policy policy) throws ServerException {
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
        try {
            boolean transactionStarted;
            if (policy.getId() == null) {
                policy.setId(UUIDGenerator.getUUID());
            }
            if (!(transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId))) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            String policiesXPath = serviceXPath + "/" + "policies";
            String policyResourcePath = policiesXPath + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)policy.getId());
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, policyResourcePath)) {
                OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
                policyWrapperElement.addAttribute("policyType", "9", null);
                OMElement idElement = omFactory.createOMElement("policyUUID", null);
                idElement.setText("" + policy.getId());
                policyWrapperElement.addChild((OMNode)idElement);
                OMElement policyElementToPersist = PersistenceUtils.createPolicyElement((Policy)policy);
                policyWrapperElement.addChild((OMNode)policyElementToPersist);
                if (!this.serviceGroupFilePM.elementExists(serviceGroupId, policiesXPath)) {
                    this.serviceGroupFilePM.put(serviceGroupId, omFactory.createOMElement("policies", null), serviceXPath);
                }
                this.serviceGroupFilePM.put(serviceGroupId, policyWrapperElement, policiesXPath);
            }
            if (isProxyService) {
                String registryServicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + axisService.getName();
                this.persistenceFactory.getServicePM().persistPolicyToRegistry(policy, "9", registryServicePath);
            }
            Map endPointMap = axisService.getEndpoints();
            ArrayList<String> lst = new ArrayList<String>();
            Iterator i$ = endPointMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                binding.getPolicySubject().attachPolicy(policy);
                String bindingName = binding.getName().getLocalPart();
                if (lst.contains(bindingName)) continue;
                lst.add(bindingName);
            }
            for (String bindingName : lst) {
                String bindingElementPath = serviceXPath + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)bindingName);
                if (this.serviceGroupFilePM.elementExists(serviceGroupId, bindingElementPath + "/" + "policyUUID" + PersistenceUtils.getXPathTextPredicate(null, (String)policy.getId()))) continue;
                OMElement bindingElement = null;
                bindingElement = this.serviceGroupFilePM.elementExists(serviceGroupId, bindingElementPath) ? (OMElement)this.serviceGroupFilePM.get(serviceGroupId, bindingElementPath) : omFactory.createOMElement("bindings", null);
                OMElement idElement = omFactory.createOMElement("policyUUID", null);
                idElement.setText("" + policy.getId());
                bindingElement.addChild((OMNode)idElement.cloneOMElement());
                this.serviceGroupFilePM.put(serviceGroupId, bindingElement, serviceXPath + "/" + "bindings");
            }
            if (!transactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new ServerException("addPoliciesToService");
        }
    }

    public void removeSecurityPolicyFromAllBindings(AxisService axisService, String uuid) throws ServerException {
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        try {
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            Map endPointMap = axisService.getEndpoints();
            ArrayList<String> lst = new ArrayList<String>();
            Iterator i$ = endPointMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                binding.getPolicySubject().detachPolicyComponent(uuid);
                String bindingName = binding.getName().getLocalPart();
                if (lst.contains(bindingName)) continue;
                lst.add(bindingName);
            }
            boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            for (String bindingName : lst) {
                String bindingElementPath = serviceXPath + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)bindingName);
                this.serviceGroupFilePM.delete(serviceGroupId, bindingElementPath + "/" + "policyUUID" + PersistenceUtils.getXPathTextPredicate(null, (String)uuid));
            }
            if (!transactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            throw new ServerException("addPoliciesToService");
        }
    }

    public void setServiceParameterElement(String serviceName, Parameter parameter) throws AxisFault {
        AxisService axisService = this.axisConfig.getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceName + "'");
        }
        Parameter p = axisService.getParameter(parameter.getName());
        if (p != null) {
            if (!p.isLocked()) {
                axisService.addParameter(parameter);
            }
        } else {
            axisService.addParameter(parameter);
        }
    }
}

