/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.wso2.xkms2.ElementSerializable;
import org.wso2.xkms2.MessageAbstractType;
import org.wso2.xkms2.PendingNotification;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.ResponseMechanism;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public abstract class RequestAbstractType
extends MessageAbstractType
implements ElementSerializable {
    private List responseMechanismList;
    private List respondWithList;
    private PendingNotification pendingNotification;
    private String originalRequestId;
    private int responseLimit = -1;

    public void addResponseMechanism(ResponseMechanism responseMechanism) {
        if (this.responseMechanismList == null) {
            this.responseMechanismList = new ArrayList();
        }
        this.responseMechanismList.add(responseMechanism);
    }

    public List getResponseMechanism() {
        return this.responseMechanismList;
    }

    public void addRespondWith(RespondWith respondWith) {
        if (this.respondWithList == null) {
            this.respondWithList = new ArrayList();
        }
        this.respondWithList.add(respondWith);
    }

    public List getRespondWith() {
        return this.respondWithList;
    }

    public void setRespondWithList(List respondWithList) {
        this.respondWithList = respondWithList;
    }

    public void setPendingNotification(PendingNotification pendingNotification) {
        this.pendingNotification = pendingNotification;
    }

    public PendingNotification getPendingNotification() {
        return this.pendingNotification;
    }

    public void setOriginalRequestId(String originalRequestId) {
        this.originalRequestId = originalRequestId;
    }

    public String getOriginalRequestId() {
        return this.originalRequestId;
    }

    public void setResponseLimit(int responseLimit) {
        this.responseLimit = responseLimit;
    }

    public int getResponseLimit() {
        return this.responseLimit;
    }

    public void setResponseMechanismList(List responseMechanismList) {
        this.responseMechanismList = responseMechanismList;
    }

    protected void serialize(OMFactory factory, OMElement container) throws XKMSException {
        Iterator iterator;
        super.serialize(factory, container);
        if (this.responseMechanismList != null) {
            iterator = this.responseMechanismList.iterator();
            while (iterator.hasNext()) {
                ResponseMechanism responseMechanism = (ResponseMechanism)iterator.next();
                OMElement responseMechanismEle = factory.createOMElement(XKMS2Constants.ELE_RESPONSE_MECHANISM);
                responseMechanismEle.setText(responseMechanism.getAnyURI());
                container.addChild((OMNode)responseMechanismEle);
            }
        }
        if (this.respondWithList != null) {
            iterator = this.respondWithList.iterator();
            while (iterator.hasNext()) {
                RespondWith respondWith = (RespondWith)iterator.next();
                OMElement respondWithEle = factory.createOMElement(XKMS2Constants.ELE_RESPOND_WITH);
                respondWithEle.setText(respondWith.getAnyURI());
                container.addChild((OMNode)respondWithEle);
            }
        }
        if (this.pendingNotification != null) {
            container.addChild((OMNode)this.pendingNotification.serialize(factory));
        }
        OMNamespace emptyNs = factory.createOMNamespace("", "");
        if (this.originalRequestId != null) {
            container.addAttribute("OriginalRequestId", this.originalRequestId, emptyNs);
        }
        if (this.responseLimit != -1) {
            container.addAttribute("ResponseLimit", Integer.toBinaryString(this.responseLimit), emptyNs);
        }
    }
}

