/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import org.apache.axiom.om.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.util.XKMSUtil;

public class RSAKeyPair
implements XKMSElement {
    private byte[] modulus;
    private byte[] exponent;
    private byte[] P;
    private byte[] Q;
    private byte[] DP;
    private byte[] DQ;
    private byte[] inverseQ;
    private byte[] D;

    public byte[] getD() {
        return this.D;
    }

    public void setD(byte[] d) {
        this.D = d;
    }

    public byte[] getDP() {
        return this.DP;
    }

    public void setDP(byte[] dp) {
        this.DP = dp;
    }

    public byte[] getDQ() {
        return this.DQ;
    }

    public void setDQ(byte[] dq) {
        this.DQ = dq;
    }

    public byte[] getExponent() {
        return this.exponent;
    }

    public void setExponent(byte[] exponent) {
        this.exponent = exponent;
    }

    public byte[] getInverseQ() {
        return this.inverseQ;
    }

    public void setInverseQ(byte[] inverseQ) {
        this.inverseQ = inverseQ;
    }

    public byte[] getModulus() {
        return this.modulus;
    }

    public void setModulus(byte[] modulus) {
        this.modulus = modulus;
    }

    public byte[] getP() {
        return this.P;
    }

    public void setP(byte[] p) {
        this.P = p;
    }

    public byte[] getQ() {
        return this.Q;
    }

    public void setQ(byte[] q) {
        this.Q = q;
    }

    public Element build(Document doc) {
        Element rsaKeyPair = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:RSAKeyPair");
        XKMSUtil.setNamespace(rsaKeyPair, "http://www.w3.org/2002/03/xkms#", "xkms");
        Element modulus = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:Modulus");
        this.appendBinaryDataAsText(this.modulus, modulus, doc);
        rsaKeyPair.appendChild(modulus);
        Element exponent = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:Exponent");
        this.appendBinaryDataAsText(this.exponent, exponent, doc);
        rsaKeyPair.appendChild(exponent);
        Element P = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:P");
        this.appendBinaryDataAsText(this.P, P, doc);
        rsaKeyPair.appendChild(P);
        Element Q = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:Q");
        this.appendBinaryDataAsText(this.Q, Q, doc);
        rsaKeyPair.appendChild(Q);
        Element DP = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:DP");
        this.appendBinaryDataAsText(this.DP, DP, doc);
        rsaKeyPair.appendChild(DP);
        Element DQ = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:DQ");
        this.appendBinaryDataAsText(this.DQ, DQ, doc);
        rsaKeyPair.appendChild(DQ);
        Element inverseQ = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:InverseQ");
        this.appendBinaryDataAsText(this.inverseQ, inverseQ, doc);
        rsaKeyPair.appendChild(inverseQ);
        Element D = doc.createElementNS("http://www.w3.org/2002/03/xkms#", "xkms:D");
        this.appendBinaryDataAsText(this.D, D, doc);
        rsaKeyPair.appendChild(D);
        return rsaKeyPair;
    }

    private void appendBinaryDataAsText(byte[] binaryData, Node node, Document doc) {
        node.appendChild(this.getText(this.encode(binaryData), doc));
    }

    private Text getText(String data, Document doc) {
        return doc.createTextNode(data);
    }

    private String encode(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }
}

