/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IdResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.xkms2.KeyBinding;
import org.wso2.xkms2.LocateResult;
import org.wso2.xkms2.RecoverResult;
import org.wso2.xkms2.RegisterResult;
import org.wso2.xkms2.ReissueResult;
import org.wso2.xkms2.ValidateResult;
import org.wso2.xkms2.XKMSException;
import org.xml.sax.SAXException;

public class XKMSUtil {
    private static Log log = LogFactory.getLog((Class)XKMSUtil.class);

    public static DOOMElementMetadata getDOOMElement(OMElement body) {
        body.build();
        XMLStreamReader xmlStreamReader = body.getXMLStreamReader();
        OMFactory fac = DOOMAbstractFactory.getOMFactory();
        StAXOMBuilder builder = new StAXOMBuilder(fac, xmlStreamReader);
        return new DOOMElementMetadata(builder.getDocumentElement(), (OMDOMFactory)fac);
    }

    public static OMElement getOMElement(OMElement doomElement) {
        StAXOMBuilder builder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), doomElement.getXMLStreamReader());
        return builder.getDocumentElement();
    }

    public static Element toDOM(OMElement element) throws XKMSException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            element.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return factory.newDocumentBuilder().parse(bais).getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
        catch (SAXException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
    }

    public static OMElement toOM(Element element) throws XKMSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree((Node)element));
            StAXOMBuilder buider = new StAXOMBuilder((InputStream)new ByteArrayInputStream(bos.toByteArray()));
            return buider.getDocumentElement();
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
        catch (CanonicalizationException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
        catch (InvalidCanonicalizerException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
    }

    public static void outputDOM(Node contextNode, OutputStream os, boolean addPreamble) throws XKMSException {
        try {
            if (addPreamble) {
                os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            os.write(Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (InvalidCanonicalizerException ex) {
            log.error((Object)ex);
            throw new XKMSException(ex);
        }
        catch (CanonicalizationException ex) {
            log.error((Object)ex);
            throw new XKMSException(ex);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new XKMSException(e);
        }
    }

    public static void outputDOM(Node contextNode, OutputStream os) throws XKMSException {
        XKMSUtil.outputDOM(contextNode, os, false);
    }

    public static void appendChild(Element child, OMElement parent) {
        Document ownerDocument = ((Element)parent).getOwnerDocument();
        Node importNode = ownerDocument.importNode(child, true);
        parent.addChild((OMNode)importNode);
    }

    public static void appendAsTest(byte[] base64Binary, OMElement element) {
        ByteArrayDataSource bads = new ByteArrayDataSource(base64Binary);
        DataHandler dataHandler = new DataHandler((DataSource)bads);
        OMTextImpl text = new OMTextImpl((Object)dataHandler, element.getOMFactory());
        element.addChild((OMNode)text);
    }

    public static String getTimeDate(Date date) {
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        return zulu.format(date);
    }

    public static Key getAuthenticationKey(String authenticationCode) {
        byte[] keyMetirials = authenticationCode.getBytes();
        byte[] key = new BigInteger("1", 16).toByteArray();
        SecretKeySpec result = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, "HmacSHA1"));
            result = new SecretKeySpec(mac.doFinal(keyMetirials), "HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static XMLSignature sign(Key signKey, Element signElement) throws XKMSException {
        String xmlSignatureAlgorithm = null;
        if (signKey instanceof SecretKeySpec) {
            xmlSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        } else if (signKey instanceof PrivateKey) {
            xmlSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            throw new XKMSException("Invalid signing key type : " + signKey.getClass().getName());
        }
        String elementId = signElement.getAttribute("Id");
        if (elementId == null) {
            throw new XKMSException("Id of the signing element is not set");
        }
        String elementRefId = "#" + elementId;
        IdResolver.registerElementById((Element)signElement, (String)elementId);
        try {
            XMLSignature signature = new XMLSignature(signElement.getOwnerDocument(), "", xmlSignatureAlgorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            Transforms transforms = new Transforms(signElement.getOwnerDocument());
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.addDocument(elementRefId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            signature.sign(signKey);
            return signature;
        }
        catch (XMLSecurityException se) {
            throw new XKMSException(se);
        }
    }

    public static void sign(Key signKey, X509Certificate signCert, Element signElement) throws XKMSException {
        String elementId = signElement.getAttribute("Id");
        if (elementId == null) {
            throw new XKMSException("Id of the signing element is not set");
        }
        String elementRefId = "#" + elementId;
        IdResolver.registerElementById((Element)signElement, (String)elementId);
        try {
            XMLSignature signature = new XMLSignature(signElement.getOwnerDocument(), elementRefId, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
            signElement.appendChild(signature.getElement());
            Transforms transforms = new Transforms(signElement.getOwnerDocument());
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.addDocument(elementRefId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            signature.addKeyInfo(signCert);
            signature.addKeyInfo(signCert.getPublicKey());
            signature.sign(signKey);
        }
        catch (XMLSecurityException xmse) {
            throw new XKMSException(xmse);
        }
    }

    public static String getRamdomId() {
        return UUIDGenerator.getUUID();
    }

    public static Document getDOOMDocument() {
        return (Document)DOOMAbstractFactory.getOMFactory().createOMDocument();
    }

    public static String setNamespace(Element element, String namespace, String prefix) {
        String pre = XKMSUtil.getPrefixNS(namespace, element);
        if (pre != null) {
            return pre;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        return prefix;
    }

    public static String getPrefixNS(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring(6);
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static void print(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(bytes[i]);
        }
    }

    public static RegisterResult createRegisterResult() {
        RegisterResult result = new RegisterResult();
        result.setId(XKMSUtil.getRamdomId());
        return result;
    }

    public static KeyBinding createKeyBinding() {
        KeyBinding keyBinding = new KeyBinding();
        keyBinding.setId(XKMSUtil.getRamdomId());
        return keyBinding;
    }

    public static RecoverResult createRecoverResult() {
        RecoverResult recoverResult = new RecoverResult();
        recoverResult.setId(XKMSUtil.getRamdomId());
        return recoverResult;
    }

    public static ReissueResult creatReissueResult() {
        ReissueResult reissueResult = new ReissueResult();
        reissueResult.setId(XKMSUtil.getRamdomId());
        return reissueResult;
    }

    public static LocateResult createLocateResult() {
        LocateResult locateResult = new LocateResult();
        locateResult.setId(XKMSUtil.getRamdomId());
        return locateResult;
    }

    public static ValidateResult createValidateResult() {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setId(XKMSUtil.getRamdomId());
        return validateResult;
    }

    public static class DOOMElementMetadata {
        private OMElement element;
        private OMDOMFactory factory;

        public DOOMElementMetadata(OMElement element, OMDOMFactory factory) {
            this.element = element;
            this.factory = factory;
        }

        public OMElement getElement() {
            return this.element;
        }

        public OMDOMFactory getFactory() {
            return this.factory;
        }
    }
}

