/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.neethi.util.Service;
import org.apache.xml.security.Init;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.core.ProtocolExchange;
import org.wso2.xkms2.core.XKMSServiceExecutor;
import org.wso2.xkms2.core.XKMSServiceExecutorManager;
import org.wso2.xkms2.service.DefaultXKMSExecutor;
import org.wso2.xkms2.util.XKMSUtil;

public class XKMSMessageReceiver
extends AbstractInOutMessageReceiver {
    private boolean isInit = false;
    private ProtocolExchange protocolExchange = new ProtocolExchange();

    public void invokeBusinessLogic(MessageContext inMsgCtx, MessageContext outMsgCtx) throws AxisFault {
        try {
            if (!this.isInit) {
                this.initExecutors(inMsgCtx);
            }
            OMElement outXKMSElement = this.protocolExchange.exchangeServer(inMsgCtx);
            outXKMSElement = XKMSUtil.getOMElement(outXKMSElement);
            SOAPFactory fac = this.getSOAPFactory(inMsgCtx);
            SOAPEnvelope outEnvelop = fac.getDefaultEnvelope();
            outEnvelop.getBody().addChild((OMNode)outXKMSElement);
            outMsgCtx.setEnvelope(outEnvelop);
        }
        catch (XKMSException e) {
            e.printStackTrace();
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private void initExecutors(MessageContext inMsgCtx) throws AxisFault {
        XKMSServiceExecutor executor;
        Iterator iterator;
        String popValue;
        List<String> executorImpls = null;
        ServiceContext serviceContext = inMsgCtx.getServiceContext();
        Parameter parameter = inMsgCtx.getParameter("xkms.excutor.impls");
        if (parameter != null) {
            String paraValue = (String)parameter.getValue();
            String[] implClasses = paraValue.split(",");
            executorImpls = Arrays.asList(implClasses);
        }
        if (executorImpls == null && (popValue = System.getProperty("xkms.excutor.impls")) != null) {
            String[] implsClasses = popValue.split(",");
            executorImpls = Arrays.asList(implsClasses);
        }
        ArrayList<XKMSServiceExecutor> executorObjs = new ArrayList<XKMSServiceExecutor>();
        if (executorImpls != null) {
            iterator = executorImpls.iterator();
            while (iterator.hasNext()) {
                String className = (String)iterator.next();
                try {
                    XKMSServiceExecutor executor2 = (XKMSServiceExecutor)Class.forName(className.trim()).newInstance();
                    executorObjs.add(executor2);
                }
                catch (ClassNotFoundException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
                catch (InstantiationException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
        }
        if (executorObjs.isEmpty()) {
            Iterator providers = Service.providers((Class)XKMSServiceExecutor.class);
            while (providers.hasNext()) {
                executor = (XKMSServiceExecutor)providers.next();
                executorObjs.add(executor);
            }
        }
        if (executorObjs.isEmpty()) {
            DefaultXKMSExecutor executor3 = new DefaultXKMSExecutor();
            executorObjs.add(executor3);
        }
        iterator = executorObjs.iterator();
        while (iterator.hasNext()) {
            executor = (XKMSServiceExecutor)iterator.next();
            executor.init(serviceContext);
            String[] types = executor.getAssociatedElemenTypes();
            for (int i = 0; i < types.length; ++i) {
                XKMSServiceExecutorManager.register(types[i], executor);
            }
        }
        this.isInit = true;
    }

    static {
        Init.init();
    }
}

