/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.text.ParseException;
import java.util.Calendar;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.wso2.xkms2.ElementSerializable;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public class ValidityInterval
implements ElementSerializable {
    private Calendar notBefore;
    private Calendar notOnOrAfter;

    public ValidityInterval() {
    }

    public ValidityInterval(Calendar notBefore, Calendar notOnOrAfter) {
        this.notBefore = notBefore;
        this.notOnOrAfter = notOnOrAfter;
    }

    public void setNotBefore(Calendar notBefore) {
        this.notBefore = notBefore;
    }

    public void setNotBefore(String notBefore) throws XKMSException {
        this.notBefore = Calendar.getInstance();
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        try {
            this.notBefore.setTime(zulu.parse(notBefore));
        }
        catch (ParseException e) {
            throw new XKMSException(e);
        }
    }

    public Calendar getNotBefore() {
        return this.notBefore;
    }

    public void setNotOnOrAfter(Calendar notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
    }

    public void setOnOrAfter(String notOnOrAfter) throws XKMSException {
        this.notOnOrAfter = Calendar.getInstance();
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        try {
            this.notOnOrAfter.setTime(zulu.parse(notOnOrAfter));
        }
        catch (ParseException e) {
            throw new XKMSException(e);
        }
    }

    public Calendar getOnOrAfter() {
        return this.notOnOrAfter;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        XmlSchemaDateFormat zulu;
        OMElement validityIntervalEle = factory.createOMElement(XKMS2Constants.ELE_VALIDITY_INTERVAL);
        OMNamespace emptyNs = factory.createOMNamespace("", "");
        if (this.notBefore != null) {
            zulu = new XmlSchemaDateFormat();
            validityIntervalEle.addAttribute("NotBefore", zulu.format(this.notBefore.getTime()), emptyNs);
        }
        if (this.notOnOrAfter != null) {
            zulu = new XmlSchemaDateFormat();
            validityIntervalEle.addAttribute("NotOnOrAfter", zulu.format(this.notOnOrAfter.getTime()), emptyNs);
        }
        return validityIntervalEle;
    }
}

