/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.wso2.xkms2.ElementSerializable;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSException;

public class UseKeyWith
implements ElementSerializable {
    public static final String S_MIME = "urn:ietf:rfc:2633";
    public static final String PGP = "urn:ietf:rfc:2440";
    public static final String TLS = "urn:ietf:rfc:2246";
    public static final String TLS_HTTPS = "urn:ietf:rfc:2818";
    public static final String TLS_SMTP = "urn:ietf:rfc:2487";
    public static final String IPSEC = "urn:ietf:rfc:2401";
    public static final String PKIX = "urn:ietf:rfc:2459";
    public static final String SKI = "urn:ietf:rfc:3080";
    private String application;
    private String identifier;

    public UseKeyWith() {
    }

    public UseKeyWith(String application, String identifier) {
        this.application = application;
        this.identifier = identifier;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getApplication() {
        return this.application;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OMElement serialize(OMFactory factory) throws XKMSException {
        if (this.application != null && this.identifier != null) {
            OMElement useKeyWithEle = factory.createOMElement(XKMS2Constants.ELE_USE_KEY_WITH);
            OMNamespace emptyNs = factory.createOMNamespace("", "");
            useKeyWithEle.addAttribute("Application", this.application, emptyNs);
            useKeyWithEle.addAttribute("Identifier", this.identifier, emptyNs);
            return useKeyWithEle;
        }
        throw new XKMSException("Required attributes are not available");
    }
}

