/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.pox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityServiceHolder;

public class POXSecurityHandler
implements Handler {
    private static Log log = LogFactory.getLog(POXSecurityHandler.class);
    private HandlerDescription description;

    public void cleanup() {
    }

    public void init(HandlerDescription description) {
        this.description = description;
    }

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        if (msgCtx == null || msgCtx.getIncomingTransportName() == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!msgCtx.isDoingREST() && !this.isSOAPWithoutSecHeader(msgCtx) || !msgCtx.getIncomingTransportName().equals("https")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        AxisService service = msgCtx.getAxisService();
        if (service == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service not dispatched");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        String requiresAuthentication = (String)service.getParameterValue("DoAuthentication");
        if (requiresAuthentication != null && JavaUtils.isFalseExplicitly((String)requiresAuthentication)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        try {
            int tenantID = SuperTenantCarbonContext.getCurrentContext((MessageContext)msgCtx).getTenantId();
            UserRegistry registry = SecurityServiceHolder.getRegistryService().getConfigSystemRegistry(tenantID);
            String servicePath = "/repository/axis2/service-groups/" + service.getAxisServiceGroup().getServiceGroupName() + "/services/" + service.getName();
            Resource serviceResource = null;
            if (!registry.resourceExists(servicePath)) {
                Handler.InvocationResponse invocationResponse = Handler.InvocationResponse.CONTINUE;
                return invocationResponse;
            }
            serviceResource = registry.get(servicePath);
            if (serviceResource != null) {
                if (serviceResource.getProperty("ut.enabled") == null) {
                    Handler.InvocationResponse invocationResponse = Handler.InvocationResponse.CONTINUE;
                    return invocationResponse;
                }
            } else {
                Handler.InvocationResponse invocationResponse = Handler.InvocationResponse.CONTINUE;
                return invocationResponse;
            }
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            Map map = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
            String tmp = (String)map.get("Authorization");
            if (tmp == null) {
                tmp = (String)map.get("authorization");
            }
            String username = null;
            String password = null;
            if (tmp != null) {
                tmp = tmp.trim();
            }
            if (tmp != null && tmp.startsWith("Basic ")) {
                int i = (tmp = new String(Base64.decode((String)tmp.substring(6)))).indexOf(58);
                username = i == -1 ? tmp : tmp.substring(0, i);
                if (i != -1 && (password = tmp.substring(i + 1)) != null && password.equals("")) {
                    password = null;
                }
            }
            if (username == null || password == null || password.trim().length() == 0 || username.trim().length() == 0) {
                Handler.InvocationResponse responseHeaders;
                HttpServletResponse response;
                String servername = ServerConfiguration.getInstance().getFirstProperty("Name");
                if (servername == null || servername.trim().length() == 0) {
                    servername = "WSO2 Carbon";
                }
                if ((response = (HttpServletResponse)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) != null) {
                    response.setContentLength(0);
                    response.setStatus(401);
                    response.addHeader("WWW-Authenticate", "BASIC realm=\"" + servername + "\"");
                    response.flushBuffer();
                } else {
                    msgCtx.setProperty("NIO-ACK-Requested", (Object)"true");
                    msgCtx.setProperty("HTTP_SC", (Object)401);
                    responseHeaders = new HashMap();
                    responseHeaders.put("WWW-Authenticate", "BASIC realm=\"" + servername + "\"");
                    msgCtx.setProperty("TRANSPORT_HEADERS", (Object)responseHeaders);
                }
                responseHeaders = Handler.InvocationResponse.ABORT;
                return responseHeaders;
            }
            Document doc = Axis2Util.getDocumentFromSOAPEnvelope((SOAPEnvelope)msgCtx.getEnvelope(), (boolean)true);
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecUsernameToken utBuilder = new WSSecUsernameToken();
            utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            utBuilder.setUserInfo(username, password);
            utBuilder.build(doc, secHeader);
            WSSecTimestamp tsBuilder = new WSSecTimestamp();
            tsBuilder.build(doc, secHeader);
            msgCtx.setEnvelope(Axis2Util.getSOAPEnvelopeFromDOMDocument((Document)doc, (boolean)false));
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (WSSecurityException wssEx) {
            throw new AxisFault("WSDoAllReceiver: Error in converting to Document", (Throwable)wssEx);
        }
        catch (Exception e) {
            throw new AxisFault("System error", (Throwable)e);
        }
        finally {
            DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private boolean isSOAPWithoutSecHeader(MessageContext msgCtx) {
        SOAPHeader soapHeader = msgCtx.getEnvelope().getHeader();
        if (soapHeader == null) {
            return true;
        }
        ArrayList headerBlocks = soapHeader.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (headerBlocks != null) {
            for (SOAPHeaderBlock elem : headerBlocks) {
                if (!"Security".equals(elem.getLocalName())) continue;
                return false;
            }
        }
        return true;
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public HandlerDescription getHandlerDesc() {
        return this.description;
    }

    public String getName() {
        return "REST/POX Security handler";
    }

    public Parameter getParameter(String name) {
        return this.description.getParameter(name);
    }
}

