/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.keystore.service;

import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreAdminInterface;
import org.wso2.carbon.security.keystore.service.KeyStoreData;

public class KeyStoreAdminServiceImpl
extends AbstractAdmin
implements KeyStoreAdminInterface {
    @Override
    public KeyStoreData[] getKeyStores() throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        boolean isSuperTenant = "carbon.super".equals(super.getTenantDomain());
        return admin.getKeyStores(isSuperTenant);
    }

    @Override
    public void addKeyStore(String fileData, String filename, String password, String provider, String type, String pvtkeyPass) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.addKeyStore(fileData, filename, password, provider, type, pvtkeyPass);
    }

    @Override
    public void deleteStore(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.deleteStore(keyStoreName);
    }

    @Override
    public void importCertToStore(String fileName, String fileData, String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.importCertToStore(fileName, fileData, keyStoreName);
    }

    @Override
    public String[] getStoreEntries(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        return admin.getStoreEntries(keyStoreName);
    }

    @Override
    public KeyStoreData getKeystoreInfo(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        return admin.getKeystoreInfo(keyStoreName);
    }

    @Override
    public void removeCertFromStore(String alias, String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getCurrentContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.removeCertFromStore(alias, keyStoreName);
    }
}

