/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.config.SecurityConfigAdmin;
import org.wso2.carbon.security.internal.SecurityAxis2ConfigurationContextObserver;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class SecurityMgtServiceComponent {
    private static String POX_SECURITY_MODULE = "POXSecurityModule";
    private static Log log = LogFactory.getLog(SecurityMgtServiceComponent.class);
    private static ConfigurationContextService configContextService = null;
    private static RealmService realmService;
    private static RegistryService registryService;

    public static ConfigurationContext getServerConfigurationContext() {
        return configContextService.getServerConfigContext();
    }

    protected void activate(ComponentContext ctxt) {
        try {
            ConfigurationContext mainConfigCtx = configContextService.getServerConfigContext();
            AxisConfiguration mainAxisConfig = mainConfigCtx.getAxisConfiguration();
            BundleContext bundleCtx = ctxt.getBundleContext();
            mainAxisConfig.engageModule(POX_SECURITY_MODULE);
            bundleCtx.registerService(SecurityConfigAdmin.class.getName(), (Object)new SecurityConfigAdmin(mainAxisConfig, (Registry)registryService.getConfigSystemRegistry(), null), null);
            bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new SecurityAxis2ConfigurationContextObserver(), null);
            log.debug((Object)"Security Mgt bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate SecurityMgtServiceComponent", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        try {
            AxisConfiguration serverAxisConfig = configContextService.getServerConfigContext().getAxisConfiguration();
            if (serverAxisConfig != null) {
                serverAxisConfig.disengageModule(serverAxisConfig.getModule(POX_SECURITY_MODULE));
            }
            log.debug((Object)"Security Mgt bundle is deactivated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to deactivate SecurityMgtServiceComponent", e);
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the ConfigurationContext");
        }
        configContextService = contextService;
        SecurityServiceHolder.setConfigurationContextService(contextService);
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RegistryService");
        }
        SecurityMgtServiceComponent.registryService = registryService;
        SecurityServiceHolder.setRegistryService(registryService);
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RealmService");
        }
        SecurityMgtServiceComponent.realmService = realmService;
        SecurityServiceHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RealmService");
        }
        SecurityMgtServiceComponent.realmService = null;
        SecurityServiceHolder.setRealmService(null);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ConfigurationContext");
        }
        configContextService = null;
        SecurityServiceHolder.setConfigurationContextService(contextService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RegistryService");
        }
        SecurityMgtServiceComponent.registryService = registryService;
        SecurityServiceHolder.setRegistryService(registryService);
    }
}

