/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.deployer.schemagenarator;

import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.wso2.wsf.deployer.schemagenarator.types.ComplexType;
import org.wso2.wsf.deployer.schemagenarator.types.SimpleType;
import org.wso2.wsf.deployer.schemagenarator.types.Type;
import org.wso2.wsf.deployer.schemagenarator.types.TypeTable;

public class SchemaGenerator {
    private String schemaTargetNamespace;
    private String prefix = "ws";
    private XmlSchema xmlSchema;
    private String TYPE = "Type";
    private TypeTable typeTable;
    private String DEFAULT_SCHEMA_NAMESPACE_PREFIX = "xs";
    private String URI_2001_SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";
    private String RESPONSE = "Response";
    private NamespaceMap nameSpacesMap = new NamespaceMap();

    public NamespaceMap getNamespaceMap() {
        return this.nameSpacesMap;
    }

    public SchemaGenerator(String schemaTargetNamespace, TypeTable typeTable) {
        this.schemaTargetNamespace = schemaTargetNamespace;
        this.typeTable = typeTable;
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        this.xmlSchema = new XmlSchema(this.schemaTargetNamespace, xmlSchemaCollection);
        this.xmlSchema.setAttributeFormDefault(new XmlSchemaForm("unqualified"));
        this.xmlSchema.setElementFormDefault(new XmlSchemaForm("unqualified"));
        this.nameSpacesMap.put((Object)this.DEFAULT_SCHEMA_NAMESPACE_PREFIX, (Object)this.URI_2001_SCHEMA_XSD);
        this.nameSpacesMap.put((Object)this.prefix, (Object)this.schemaTargetNamespace);
        this.xmlSchema.setNamespaceContext((NamespacePrefixList)this.nameSpacesMap);
    }

    public XmlSchema getSchema() {
        return this.xmlSchema;
    }

    public XmlSchemaElement createInputElement(Type input, String functionName) throws Exception {
        return this.createElement(input, functionName);
    }

    public XmlSchemaElement createOutputElement(Type output, String functionName) throws Exception {
        return this.createElement(output, functionName + this.RESPONSE);
    }

    private XmlSchemaElement handleComplexType(ComplexType complexType, String functionName) throws Exception {
        XmlSchemaComplexType xmlSchemaComplexType = this.createComplexType(complexType, functionName + this.TYPE);
        if (complexType == null) {
            return null;
        }
        XmlSchemaElement xmlSchemaElement = this.createXMLSchemaElement(functionName, functionName + this.TYPE);
        xmlSchemaElement.setSchemaType((XmlSchemaType)xmlSchemaComplexType);
        xmlSchemaElement.setQName(new QName(this.schemaTargetNamespace, functionName));
        return xmlSchemaElement;
    }

    private XmlSchemaElement createElement(Type param, String functionName) throws Exception {
        ComplexType complexType;
        XmlSchemaElement xmlSchemaElement = null;
        if (param instanceof ComplexType) {
            complexType = (ComplexType)param;
            xmlSchemaElement = this.handleComplexType(complexType, functionName);
        } else if (param instanceof SimpleType) {
            complexType = new ComplexType();
            complexType.addMember(param);
            complexType.setName(functionName);
            xmlSchemaElement = this.handleComplexType(complexType, functionName);
        }
        if (xmlSchemaElement == null) {
            return null;
        }
        QName element = new QName(this.schemaTargetNamespace, functionName, this.prefix);
        this.xmlSchema.getItems().add((XmlSchemaObject)xmlSchemaElement);
        this.xmlSchema.getElements().add(element, (XmlSchemaObject)xmlSchemaElement);
        return xmlSchemaElement;
    }

    private XmlSchemaComplexType createComplexType(ComplexType complexType, String elementName) throws Exception {
        QName element = new QName(this.schemaTargetNamespace, elementName, this.prefix);
        XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(this.xmlSchema);
        xmlSchemaComplexType.setName(elementName);
        this.xmlSchema.getItems().add((XmlSchemaObject)xmlSchemaComplexType);
        XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
        for (Object object : complexType.getMembers()) {
            ComplexType complexTypeParam;
            XmlSchemaElement xmlSchemaElement;
            if (object instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)object;
                xmlSchemaElement = this.createXMLSchemaElement(simpleType.getName(), simpleType.getType());
                if (xmlSchemaElement == null) continue;
                xmlSchemaSequence.getItems().add((XmlSchemaObject)xmlSchemaElement);
                QName simpleElement = new QName(this.schemaTargetNamespace, simpleType.getName(), this.prefix);
                XmlSchemaSimpleType xmlSchemaSimpleType = new XmlSchemaSimpleType(this.xmlSchema);
                xmlSchemaSimpleType.setName(simpleType.getName());
                xmlSchemaElement.setSchemaType((XmlSchemaType)xmlSchemaSimpleType);
                continue;
            }
            if (!(object instanceof ComplexType) || (xmlSchemaElement = this.handleComplexType(complexTypeParam = (ComplexType)object, elementName + complexTypeParam.getName() + this.TYPE)) == null) continue;
            xmlSchemaElement.setName(complexTypeParam.getName());
            xmlSchemaSequence.getItems().add((XmlSchemaObject)xmlSchemaElement);
        }
        xmlSchemaComplexType.setParticle((XmlSchemaParticle)xmlSchemaSequence);
        this.typeTable.addComplexSchema(elementName, element);
        return xmlSchemaComplexType;
    }

    private XmlSchemaElement createXMLSchemaElement(String name, String paramType) throws Exception {
        XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
        xmlSchemaElement.setName(name);
        QName qName = this.typeTable.getQNamefortheType(paramType);
        if (qName == null) {
            throw new Exception("No matching schematype could be found for the type : " + paramType);
        }
        xmlSchemaElement.setSchemaTypeName(qName);
        return xmlSchemaElement;
    }

    public String getSchemaTargetNamespace() {
        return this.schemaTargetNamespace;
    }

    private XmlSchemaSimpleType handleEnumeration(String name, String[] enums) {
        XmlSchemaSimpleTypeRestriction simpleTypeRestriction = new XmlSchemaSimpleTypeRestriction();
        simpleTypeRestriction.setBaseTypeName(Constants.XSD_STRING);
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(this.xmlSchema);
        simpleType.setName(name);
        simpleType.setContent((XmlSchemaSimpleTypeContent)simpleTypeRestriction);
        for (int i = 0; i < enums.length; ++i) {
            String enumeration = enums[i].trim();
            XmlSchemaEnumerationFacet enumerationFacet = new XmlSchemaEnumerationFacet();
            enumerationFacet.setValue((Object)enumeration);
            simpleTypeRestriction.getFacets().add((XmlSchemaObject)enumerationFacet);
        }
        return simpleType;
    }
}

