/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.installer.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.sample.installer.ui.ServerInfoBean;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static String TENANT_REG_AGENT_CONF_FILENAME = "tenant-reg-agent.xml";
    private static List<ServerInfoBean> listenerServers = new ArrayList<ServerInfoBean>();

    public static String login(String serverUrl, String userName, String password, ConfigurationContext confContext) throws UserStoreException {
        String sessionCookie = null;
        try {
            AuthenticationAdminClient client = new AuthenticationAdminClient(confContext, serverUrl, null, null, false);
            boolean isLogin = client.login(userName, password, "127.0.0.1");
            if (isLogin) {
                sessionCookie = client.getAdminCookie();
            }
        }
        catch (Exception e) {
            throw new UserStoreException("Error in login to the server server: " + serverUrl + "username: " + userName + ".", (Throwable)e);
        }
        return sessionCookie;
    }

    private static void loadConfig() throws Exception {
        String configFilename = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + TENANT_REG_AGENT_CONF_FILENAME;
        OMElement agentConfigEle = Util.buildOMElement(new FileInputStream(configFilename));
        Iterator configChildren = agentConfigEle.getChildElements();
        while (configChildren.hasNext()) {
            Object configObj = configChildren.next();
            if (!(configObj instanceof OMElement)) continue;
            OMElement serverConfigEle = (OMElement)configObj;
            Iterator serverConfigChildren = serverConfigEle.getChildElements();
            ServerInfoBean server = new ServerInfoBean();
            while (serverConfigChildren.hasNext()) {
                Object childObj = serverConfigChildren.next();
                if (!(childObj instanceof OMElement)) continue;
                OMElement childEle = (OMElement)childObj;
                if (new QName(null, "serverUrl").equals(childEle.getQName())) {
                    String serverUrl = childEle.getText();
                    server.setServerUrl(serverUrl);
                    continue;
                }
                if (new QName(null, "userName").equals(childEle.getQName())) {
                    String userName = childEle.getText();
                    server.setUserName(userName);
                    continue;
                }
                if (!new QName(null, "password").equals(childEle.getQName())) continue;
                String password = childEle.getText();
                server.setPassword(password);
            }
            listenerServers.add(server);
        }
    }

    private static OMElement buildOMElement(InputStream inputStream) throws Exception {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static ServerInfoBean[] getListenerServers() throws Exception {
        Util.loadConfig();
        return listenerServers.toArray(new ServerInfoBean[listenerServers.size()]);
    }
}

