/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.installer.ui;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.sample.installer.stub.SampleDeployerCallbackHandler;
import org.wso2.carbon.sample.installer.stub.SampleDeployerStub;
import org.wso2.carbon.sample.installer.stub.SampleInformation;
import org.wso2.carbon.sample.installer.ui.ServerInfoBean;
import org.wso2.carbon.sample.installer.ui.Util;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SampleDeployerClient {
    private static final Log log = LogFactory.getLog(SampleDeployerClient.class);
    private static final String SERVICE = "SampleDeployer";
    private SampleDeployerStub stub;
    private String epr;
    private ConfigurationContext confContext;
    private static Map<String, Long> tracker = new ConcurrentHashMap<String, Long>();
    private static ExecutorService sampleInstallerService;
    private static InstallationRequestCleaner requestCleaner;
    public static final int MAX_WAIT_TIMESTAMP_MINS = 60;
    private SampleDeployerCallbackData callbackData = new SampleDeployerCallbackData();
    private SampleDeployerCallbackHandler callback = new SampleDeployerCallbackHandler(this.callbackData){

        public void receiveResultdeploySample(boolean result) {
            this.getData().setComplete(result);
        }

        public void receiveErrordeploySample(Exception e) {
            this.getData().setException(e);
        }

        public void receiveResultuploadSample(boolean result) {
            this.getData().setComplete(result);
        }

        public void receiveErroruploadSample(Exception e) {
            this.getData().setException(e);
        }

        private SampleDeployerCallbackData getData() {
            return (SampleDeployerCallbackData)this.getClientData();
        }
    };

    public SampleDeployerClient(String cookie, String serverURL, ConfigurationContext configContext) throws CarbonException {
        this.epr = serverURL + SERVICE;
        this.confContext = configContext;
        try {
            this.stub = new SampleDeployerStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate SampleDeployer service client.";
            log.error((Object)msg, (Throwable)axisFault);
            throw new CarbonException(msg, (Throwable)axisFault);
        }
    }

    public SampleDeployerClient(ServletConfig config, HttpSession session) throws CarbonException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = serverURL + SERVICE;
        try {
            this.stub = new SampleDeployerStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate SampleDeployer service client.";
            log.error((Object)msg, (Throwable)axisFault);
            throw new CarbonException(msg, (Throwable)axisFault);
        }
    }

    private boolean sampleUploader(String sampleName, String tenantDomain) throws CarbonException {
        try {
            this.stub.uploadSample(sampleName, tenantDomain);
            return true;
        }
        catch (Exception e) {
            String msg = "Failed to upload.";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, (Throwable)e);
        }
    }

    public void sampleDeployer(String sampleName, String tenantDomain) throws CarbonException {
        block7: {
            try {
                SampleInformation[] samples = this.getSampleInformation(sampleName, tenantDomain);
                if (samples == null) break block7;
                for (SampleInformation sample : samples) {
                    if (!sample.getInstallable()) continue;
                    if (this.sampleUploader(sample.getFileName(), tenantDomain)) {
                        ServerInfoBean[] servers = Util.getListenerServers();
                        String[] serviceEPRs = sample.getServiceEPRs();
                        SampleDeployerStub[] deployerStubs = new SampleDeployerStub[serviceEPRs.length];
                        for (int j = 0; j < deployerStubs.length; ++j) {
                            String sampleDeployerCookie = null;
                            for (ServerInfoBean server : servers) {
                                if (!server.getServerUrl().equals(serviceEPRs[j])) continue;
                                sampleDeployerCookie = Util.login(server.getServerUrl(), server.getUserName(), server.getPassword(), this.confContext);
                                break;
                            }
                            if (sampleDeployerCookie == null) {
                                log.warn((Object)("Unable to deploy sample on server: " + serviceEPRs[j] + ". Login Failed."));
                            }
                            deployerStubs[j] = new SampleDeployerStub(this.confContext, serviceEPRs[j] + SERVICE);
                            ServiceClient client = deployerStubs[j]._getServiceClient();
                            Options options = client.getOptions();
                            options.setManageSession(true);
                            options.setProperty("Cookie", (Object)sampleDeployerCookie);
                            deployerStubs[j].deploySample(sample.getFileName(), tenantDomain);
                        }
                        continue;
                    }
                    log.error((Object)("An error occurred while uploading sample: " + sampleName));
                }
            }
            catch (Exception e) {
                String msg = "Failed to deploy sample: " + sampleName;
                log.error((Object)msg, (Throwable)e);
                throw new CarbonException(msg, (Throwable)e);
            }
        }
    }

    public SampleInformation[] getSampleInformation(String sampleName, String tenantDomain) throws CarbonException {
        try {
            SampleInformation[] samples = this.stub.getSampleInformation(tenantDomain);
            if (sampleName.equals("all")) {
                return samples;
            }
            for (SampleInformation sample : samples) {
                if (!sample.getFileName().equalsIgnoreCase(sampleName)) continue;
                SampleInformation[] sampleInfo = new SampleInformation[]{sample};
                return sampleInfo;
            }
        }
        catch (RemoteException e) {
            String msg = "Failed to get sample information";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, (Throwable)e);
        }
        return null;
    }

    public void setPolicyPermission() throws RemoteException {
        this.stub.setPolicyPermission();
    }

    public String addToQueue(String sampleName, HttpSession session) {
        Long timestampMins;
        String tenantDomain;
        if (sampleInstallerService == null) {
            sampleInstallerService = Executors.newCachedThreadPool();
        }
        if (requestCleaner == null) {
            requestCleaner = new InstallationRequestCleaner();
            requestCleaner.start();
        }
        if ((tenantDomain = (String)session.getAttribute("tenantDomain")) != null && tracker.containsKey(tenantDomain) && (timestampMins = Long.valueOf((System.nanoTime() - tracker.get(tenantDomain)) / 1000L / 1000L / 1000L / 60L)) < 60L) {
            return "waiting";
        }
        SampleInstallerWorker installerWorker = new SampleInstallerWorker(tenantDomain, sampleName);
        sampleInstallerService.execute(installerWorker);
        return "success";
    }

    private class InstallationRequestCleaner
    extends Thread {
        private InstallationRequestCleaner() {
        }

        public void run() {
            while (true) {
                long maxSleepInterval = 0L;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Running InstallationRequestCleaner");
                }
                if (!tracker.isEmpty()) {
                    for (String tenantDomain : tracker.keySet()) {
                        Long timeStamp = (System.nanoTime() - (Long)tracker.get(tenantDomain)) / 1000L / 1000L / 1000L / 60L;
                        long l = maxSleepInterval = maxSleepInterval < timeStamp ? timeStamp : maxSleepInterval;
                        if (timeStamp < 60L) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("InstallationRequestCleaner removed " + tenantDomain));
                        }
                        tracker.remove(tenantDomain);
                    }
                    try {
                        InstallationRequestCleaner.sleep((60L - maxSleepInterval) * 60L * 1000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    InstallationRequestCleaner.sleep(3600000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class SampleInstallerWorker
    extends Thread {
        private String tenantDomain;
        private String sampleName;

        public SampleInstallerWorker(String tenantDomain, String sampleName) {
            this.tenantDomain = tenantDomain;
            this.sampleName = sampleName;
        }

        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("******* Starting the sample installer worker for " + this.tenantDomain + " *******"));
            }
            try {
                SampleDeployerClient.this.sampleDeployer(this.sampleName, this.tenantDomain);
                tracker.put(this.tenantDomain, System.nanoTime());
            }
            catch (CarbonException e) {
                String msg = "An error occurred while installing " + this.sampleName + " for tenant " + this.tenantDomain;
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private static class SampleDeployerCallbackData {
        private boolean isComplete = false;
        private boolean result = false;
        private Exception exception = null;

        private SampleDeployerCallbackData() {
        }

        public void setComplete(boolean result) {
            this.result = result;
            this.isComplete = true;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleCallback() throws Exception {
            this.result = false;
            int i = 0;
            try {
                while (!this.isComplete && this.exception == null) {
                    Thread.sleep(500L);
                    if (++i <= 288000) continue;
                    throw new Exception("Response not received within 4 hours");
                }
                if (!this.isComplete) {
                    throw this.exception;
                }
            }
            finally {
                this.isComplete = false;
                this.exception = null;
            }
            return this.result;
        }
    }
}

