/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.upload;

import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.ws.stub.fileupload.RuleServiceFileUploadAdminStub;
import org.wso2.carbon.rule.ws.ui.RuleServiceClientException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class RuleServiceFileUploadClient {
    private static final Log log = LogFactory.getLog(RuleServiceFileUploadClient.class);
    private RuleServiceFileUploadAdminStub serviceUploaderStub;

    public RuleServiceFileUploadClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        this.init(ctx, serverURL, cookie);
    }

    public RuleServiceFileUploadClient(ServletContext servletContext, HttpSession httpSession) throws Exception {
        ConfigurationContext ctx = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)httpSession.getAttribute("wso2carbon.admin.service.cookie");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)httpSession);
        this.init(ctx, serverURL, cookie);
    }

    private void init(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String serviceUploaderServiceEPR = serverURL + "RuleServiceFileUploadAdmin";
        this.serviceUploaderStub = new RuleServiceFileUploadAdminStub(ctx, serviceUploaderServiceEPR);
        ServiceClient client = this.serviceUploaderStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setProperty("enableMTOM", (Object)"true");
        options.setTimeOutInMilliSeconds(10000L);
    }

    public void uploadService(String fileName, DataHandler dataHandler) {
        try {
            this.serviceUploaderStub.uploadService(fileName, dataHandler);
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error uploading rule archive : " + fileName, e);
        }
    }
}

