/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.rule.ws.ui.wizard.RuleServiceAdminClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class FactsUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".jar"};

    /*
     * Could not resolve type clashes
     */
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        Map formFieldsMap = this.getFormFieldsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/ruleservices/rule_service_wizard_step3.jsp"));
            return false;
        }
        String ruleServiceName = (String)((ArrayList)formFieldsMap.get("ruleServiceName")).get(0);
        RuleServiceAdminClient adminClient = new RuleServiceAdminClient(this.configurationContext, serverURL, cookie);
        String msg = "";
        String fileToRedirect = "";
        try {
            for (String o : fileItemsMap.keySet()) {
                String fileName;
                FileItemData fileItemData;
                String fieldName = o;
                if ("factFilename".equals(fieldName)) {
                    fileItemData = (FileItemData)((ArrayList)fileItemsMap.get(fieldName)).get(0);
                    fileName = this.getFileName(fileItemData.getFileItem().getName());
                    this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                    if (fileName.endsWith(".jar")) {
                        String[] mergedFacts;
                        HashSet<String> factSet;
                        String[] facts = adminClient.uploadFacts(ruleServiceName, fileName, fileItemData.getDataHandler(), request);
                        request.getSession().setAttribute("facts", (Object)facts);
                        String[] allFacts = (String[])request.getSession().getAttribute("allFacts");
                        if (allFacts != null) {
                            if (allFacts.length > 0) {
                                factSet = new HashSet();
                                for (String fact : allFacts) {
                                    factSet.add(fact);
                                }
                                for (String fact : facts) {
                                    factSet.add(fact);
                                }
                                mergedFacts = factSet.toArray(new String[factSet.size()]);
                                request.getSession().setAttribute("allFacts", (Object)mergedFacts);
                            }
                        } else {
                            factSet = new HashSet<String>();
                            for (String fact : facts) {
                                factSet.add(fact);
                            }
                            mergedFacts = factSet.toArray(new String[factSet.size()]);
                            request.getSession().setAttribute("allFacts", (Object)mergedFacts);
                        }
                    } else {
                        throw new CarbonException("File with extension " + fileName + " is not supported!");
                    }
                    msg = "Facts file uploaded successfully.";
                    fileToRedirect = "/ruleservices/rule_service_wizard_step3.jsp";
                    continue;
                }
                if (!"ruleFilename".equals(fieldName)) continue;
                fileItemData = (FileItemData)((ArrayList)fileItemsMap.get(fieldName)).get(0);
                fileName = this.getFileName(fileItemData.getFileItem().getName());
                adminClient.uploadRuleFile(ruleServiceName, fileName, fileItemData.getDataHandler(), request);
                String[] ruleFileNames = adminClient.getRuleFileList(adminClient.getRuleServiceDescription(request), request.getSession());
                List<Object> fileNames = new ArrayList();
                fileNames = Arrays.asList(ruleFileNames);
                HashMap<String, String> scriptList = (HashMap<String, String>)request.getSession().getAttribute("ruleScript");
                if (scriptList == null) {
                    scriptList = new HashMap<String, String>();
                }
                for (String filename : fileNames) {
                    scriptList.put(filename, "file");
                }
                request.getSession().setAttribute("ruleScript", scriptList);
                msg = "Rule Script file uploaded successfully.";
                fileToRedirect = "/ruleservices/rule_service_wizard_step2.jsp";
            }
            response.setContentType("text/html; charset=utf-8");
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + fileToRedirect));
            return true;
        }
        catch (Exception e) {
            msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + fileToRedirect));
            return false;
        }
    }
}

