/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.ns;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.ws.ui.ns.NameSpacesInformation;
import org.wso2.carbon.rule.ws.ui.ns.NameSpacesInformationRepository;

public class NameSpacesFactory {
    private static final Log log = LogFactory.getLog(NameSpacesFactory.class);
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    private static NameSpacesFactory ourInstance = new NameSpacesFactory();

    public static NameSpacesFactory getInstance() {
        return ourInstance;
    }

    private NameSpacesFactory() {
    }

    public Collection<OMNamespace> createNameSpaces(String id, String opName, HttpSession httpSession) {
        ArrayList<OMNamespace> namespaces = new ArrayList<OMNamespace>();
        if (!NameSpacesFactory.assertIDNotEmpty(id) || !NameSpacesFactory.assertOperationNameNotEmpty(opName)) {
            return null;
        }
        NameSpacesInformationRepository repository = (NameSpacesInformationRepository)httpSession.getAttribute("NameSpacesInformationRepository");
        if (repository == null) {
            return namespaces;
        }
        NameSpacesInformation information = repository.getNameSpacesInformation(opName, id);
        if (information == null) {
            return namespaces;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting NameSpaces :" + information + " for id :" + id));
        }
        Collection<String> ns = information.getPrefixes();
        for (String prefix : ns) {
            String uri;
            if (prefix == null || (uri = information.getNameSpaceURI(prefix)) == null || "".equals(uri)) continue;
            namespaces.add(OM_FACTORY.createOMNamespace(uri, prefix));
        }
        information.removeAllNameSpaces();
        return namespaces;
    }

    private static boolean assertIDNotEmpty(String id) {
        if (id == null || "".equals(id)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided id is empty or null ,returning a null as QName");
            }
            return false;
        }
        return true;
    }

    private static boolean assertOperationNameNotEmpty(String source) {
        if (source == null || "".equals(source)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided operation is empty or null ,returning a null as QName");
            }
            return false;
        }
        return true;
    }
}

