/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.common.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.wso2.carbon.rule.common.Fact;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;

public class HelperUtil {
    public static String getAttributeValue(OMElement omElement, String attributeName) {
        return omElement.getAttributeValue(new QName("", attributeName));
    }

    public static void processFactDefaultValues(List<Fact> facts, ClassLoader classLoader) throws RuleConfigurationException {
        for (Fact fact : facts) {
            try {
                fact.setTypeClass(classLoader.loadClass(fact.getType()));
                if (fact.getElementName() == null) {
                    String typeName = fact.getType();
                    if (typeName.indexOf(".") > -1) {
                        typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
                    }
                    typeName = typeName.substring(0, 1).toLowerCase() + typeName.substring(1);
                    fact.setElementName(typeName);
                }
                if (fact.getNamespace() != null) continue;
                DefaultNamespaceGenerator namespaceGenerator = new DefaultNamespaceGenerator();
                fact.setNamespace(namespaceGenerator.namespaceFromPackageName(fact.getTypeClass().getPackage().getName()).toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuleConfigurationException("Can not load the class", e);
            }
        }
    }

    public static Map<String, String> getPrefixToNamespaceMap(OMElement omElement) {
        Iterator iterator = omElement.getAllDeclaredNamespaces();
        HashMap<String, String> prefixToNamespaceMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            OMNamespace omNamespace = (OMNamespace)iterator.next();
            prefixToNamespaceMap.put(omNamespace.getPrefix(), omNamespace.getNamespaceURI());
        }
        return prefixToNamespaceMap;
    }
}

