/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.wizard;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.wso2.carbon.rule.common.Fact;
import org.wso2.carbon.rule.common.Input;
import org.wso2.carbon.rule.common.Operation;
import org.wso2.carbon.rule.common.Output;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.common.RuleSet;
import org.wso2.carbon.rule.ws.ui.ns.NameSpacesInformation;
import org.wso2.carbon.rule.ws.ui.ns.NameSpacesInformationRepository;

public class RuleServiceManagementHelper {
    private static String EMPTY_STRING = "";

    public static void saveStep1(RuleService ruleService, HttpServletRequest request) {
        String serviceScope;
        String description;
        String ruleServiceTNS;
        String stepID = request.getParameter("stepID");
        if (!"step1".equals(stepID)) {
            return;
        }
        String serviceName = request.getParameter("ruleServiceName");
        if (serviceName != null && !"".equals(serviceName.trim())) {
            String name = ruleService.getName();
            if (name == null || "".equals(name)) {
                ruleService.setEditable(true);
            }
            ruleService.setName(serviceName);
        }
        if ((ruleServiceTNS = request.getParameter("ruleServiceTNS")) != null && !"".equals(ruleServiceTNS)) {
            ruleService.setTargetNamespace(ruleServiceTNS.trim());
        }
        if ((description = request.getParameter("description")) != null && !"".equals(description.trim())) {
            ruleService.setDescription(description.trim());
        }
        if ((serviceScope = request.getParameter("ruleServiceScope")) != null && !"".equals(serviceScope)) {
            ruleService.setScope(serviceScope.trim());
        }
        System.out.println(serviceScope);
        String generateServicesXML = request.getParameter("generateServiceXML");
        if (generateServicesXML != null) {
            ruleService.setContainsServicesXML(true);
        } else {
            ruleService.setContainsServicesXML(false);
        }
        ruleService.setExtension("aar");
    }

    public static void saveStep2(RuleService ruleService, HttpServletRequest request) {
        String stepID = request.getParameter("stepID");
        if (!"step2".equals(stepID)) {
            return;
        }
        RuleSet ruleSet = ruleService.getRuleSet();
        if (ruleSet == null) {
            ruleSet = new RuleSet();
            ruleService.setRuleSet(ruleSet);
        }
        ArrayList scriptNameList = new ArrayList();
        String ruleScriptType = request.getParameter("ruleSourceType");
        String ruleResourceType = request.getParameter("ruleResouceType");
        Map scriptList = (Map)request.getSession().getAttribute("ruleScript");
        String inlinedSource = request.getParameter("ruleSourceInlined");
        if (inlinedSource != null && !"".equals(inlinedSource.trim())) {
            Rule rule = new Rule();
            ruleSet.addRule(rule);
            rule.setSourceType("inline");
            rule.setResourceType(ruleResourceType);
            rule.setValue(inlinedSource.trim());
        } else if ("key".equals(ruleScriptType) || "url".equals(ruleScriptType) || "upload".equals(ruleResourceType)) {
            ruleSet.clearRules();
            ArrayList paths = null;
            if (scriptList != null && !scriptList.isEmpty()) {
                paths = new ArrayList(scriptList.keySet());
            }
            if (paths != null && !paths.isEmpty()) {
                for (String scriptName : paths) {
                    String sourceType = (String)scriptList.get(scriptName);
                    Rule rule = new Rule();
                    rule.setSourceType(sourceType);
                    rule.setResourceType(ruleResourceType);
                    rule.setValue(scriptName.trim());
                    ruleSet.addRule(rule);
                }
            }
        }
    }

    public static void saveStep5(RuleService ruleService, HttpServletRequest request) {
        String outputFactCounter;
        String inputFactCounter;
        String stepID = request.getParameter("stepID");
        if (!"step5".equals(stepID)) {
            return;
        }
        request.getSession().removeAttribute("ruleScript");
        String operationName = request.getParameter("operationName");
        Operation operation = ruleService.getOperation(operationName);
        NameSpacesInformationRepository repository = (NameSpacesInformationRepository)request.getSession().getAttribute("NameSpacesInformationRepository");
        NameSpacesInformation information = null;
        String ownerID = request.getParameter("opName");
        if (ownerID == null || "".equals(ownerID)) {
            ownerID = "default";
        }
        if (operation == null) {
            operation = new Operation();
            operation.setName(operationName);
            ruleService.addOperation(operation);
        } else {
            operation.getInput().getFacts().clear();
            operation.getOutput().getFacts().clear();
        }
        Input input = operation.getInput();
        String inputWrapperName = request.getParameter("inputWrapperName");
        String inputNameSpace = request.getParameter("inputNameSpace");
        if (input == null) {
            input = new Input();
            operation.setInput(input);
        }
        if (inputWrapperName != null && !"".equals(inputWrapperName)) {
            input.setWrapperElementName(inputWrapperName);
        }
        if (inputNameSpace != null && !"".equals(inputNameSpace)) {
            input.setNameSpace(inputNameSpace);
        }
        if ((inputFactCounter = request.getParameter("inputFactCount")) != null && !"".equals(inputFactCounter)) {
            int inputFactCount = 0;
            try {
                inputFactCount = Integer.parseInt(inputFactCounter.trim());
                for (int i = 0; i < inputFactCount; ++i) {
                    String name = request.getParameter("inputFactName" + i);
                    String type = request.getParameter("inputFactType" + i);
                    String nameSpace = request.getParameter("inputFactNameSpace" + i);
                    String xPath = request.getParameter("inputFactXPath" + i);
                    String id = "inputFactValue" + i;
                    if (type == null || "".equals(type)) continue;
                    Fact fact = new Fact();
                    input.addFact(fact);
                    fact.setType(type.trim());
                    if (name != null && !"".equals(name)) {
                        fact.setElementName(name.trim());
                    }
                    if (nameSpace != null && !"".equals(nameSpace)) {
                        fact.setNamespace(nameSpace.trim());
                    }
                    if (xPath != null && !"".equals(xPath)) {
                        fact.setXpath(xPath.trim());
                    }
                    if (repository == null || (information = repository.getNameSpacesInformation(ownerID, id)) == null) continue;
                    fact.setPrefixToNamespaceMap(information.getNameSpaces());
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        Output output = operation.getOutput();
        String outputWrapperName = request.getParameter("outputWrapperName");
        String outputNameSpace = request.getParameter("outputNameSpace");
        if (output == null) {
            output = new Output();
            operation.setOutput(output);
        }
        if (outputWrapperName != null && !"".equals(outputWrapperName)) {
            output.setWrapperElementName(outputWrapperName);
        }
        if (outputNameSpace != null && !"".equals(outputNameSpace)) {
            output.setNameSpace(outputNameSpace);
        }
        if ((outputFactCounter = request.getParameter("outputFactCount")) != null && !"".equals(outputFactCounter)) {
            int outputFactCount = 0;
            try {
                outputFactCount = Integer.parseInt(outputFactCounter.trim());
                for (int i = 0; i < outputFactCount; ++i) {
                    String name = request.getParameter("outputFactName" + i);
                    String type = request.getParameter("outputFactType" + i);
                    String nameSpace = request.getParameter("outputFactNameSpace" + i);
                    String xPath = request.getParameter("outputFactXPath" + i);
                    String id = "outputFactValue" + i;
                    if (type == null || "".equals(type)) continue;
                    Fact fact = new Fact();
                    output.addFact(fact);
                    fact.setType(type.trim());
                    if (name != null && !"".equals(name)) {
                        fact.setElementName(name.trim());
                    }
                    if (nameSpace != null && !"".equals(nameSpace)) {
                        fact.setNamespace(nameSpace.trim());
                    }
                    if (xPath != null && !"".equals(xPath)) {
                        fact.setXpath(xPath.trim());
                    }
                    if (repository == null || (information = repository.getNameSpacesInformation(ownerID, id)) == null) continue;
                    fact.setPrefixToNamespaceMap(information.getNameSpaces());
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
    }
}

