/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.upload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.rule.ws.ui.upload.RuleServiceFileUploadClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class RuleServiceFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".aar", ".rsl"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed. No files are specified";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/ruleservices/ruleserviceupload.jsp"));
            return false;
        }
        RuleServiceFileUploadClient serviceUploaderClient = new RuleServiceFileUploadClient(this.configurationContext, serverURL, cookie);
        try {
            Iterator i$ = fileItemsMap.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String fieldName = o = (String)i$.next();
                FileItemData fileItemData = (FileItemData)((ArrayList)fileItemsMap.get(fieldName)).get(0);
                String fileName = this.getFileName(fileItemData.getFileItem().getName());
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                if (fileName.endsWith(".aar") || fileName.endsWith(".rsl")) {
                    serviceUploaderClient.uploadService(fileName, fileItemData.getDataHandler());
                    continue;
                }
                throw new CarbonException("File with extension " + fileName + " is not supported!. Supported extensions are : .aar and .rsl");
            }
            response.setContentType("text/html; charset=utf-8");
            String msg = "Rule Service archive file uploaded successfully.";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/service-mgt/index.jsp"));
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/ruleservices/ruleserviceupload.jsp"));
            return false;
        }
    }
}

