/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.wizard;

import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.common.config.RuleServiceHelper;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.ws.stub.wizard.RuleServiceAdminRuleServiceAdminException;
import org.wso2.carbon.rule.ws.stub.wizard.RuleServiceAdminStub;
import org.wso2.carbon.rule.ws.ui.RuleServiceClientException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class RuleServiceAdminClient {
    private static final Log log = LogFactory.getLog(RuleServiceAdminClient.class);
    private RuleServiceAdminStub ruleServiceAdminStub;
    public static final String RULE_SERVIE = "ruleservice";
    public static final String FACTS = "facts";
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    private static final OMNamespace NULL_NS = OM_FACTORY.createOMNamespace("", "");

    public RuleServiceAdminClient(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        this.init(ctx, serverURL, cookie);
    }

    public RuleServiceAdminClient(ServletContext servletContext, HttpSession httpSession) throws Exception {
        ConfigurationContext ctx = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
        String cookie = (String)httpSession.getAttribute("wso2carbon.admin.service.cookie");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)servletContext, (HttpSession)httpSession);
        this.init(ctx, serverURL, cookie);
    }

    private void init(ConfigurationContext ctx, String serverURL, String cookie) throws AxisFault {
        String serviceUploaderServiceEPR = serverURL + "RuleServiceAdmin";
        this.ruleServiceAdminStub = new RuleServiceAdminStub(ctx, serviceUploaderServiceEPR);
        ServiceClient client = this.ruleServiceAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
        options.setProperty("enableMTOM", (Object)"true");
        options.setTimeOutInMilliSeconds(10000L);
    }

    public RuleService getRuleServiceDescription(HttpServletRequest request) {
        String serviceName = request.getParameter("serviceName");
        RuleService ruleService = (RuleService)request.getSession().getAttribute(RULE_SERVIE);
        if (ruleService != null) {
            if (serviceName != null && !"".equals(serviceName)) {
                String name = ruleService.getName();
                if (serviceName.equals(name)) {
                    return ruleService;
                }
            } else {
                return ruleService;
            }
        }
        if (serviceName != null && !"".equals(serviceName)) {
            ruleService = this.getRuleService(serviceName.trim());
        } else {
            ruleService = new RuleService();
            ruleService.setExtension("rsl");
            ruleService.setTargetNamespace("http://wso2.org/carbon/rules");
        }
        request.getSession().setAttribute(RULE_SERVIE, (Object)ruleService);
        return ruleService;
    }

    public String[] uploadFacts(String serviceName, String fileName, DataHandler dataHandler, HttpServletRequest request) {
        try {
            String[] strings = this.ruleServiceAdminStub.uploadFacts(serviceName, fileName, dataHandler);
            RuleService ruleService = this.getRuleServiceDescription(request);
            if (ruleService != null) {
                ruleService.setExtension("aar");
            }
            return strings;
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error uploading facts : " + fileName);
        }
    }

    public void uploadRuleFile(String serviceName, String fileName, DataHandler dataHandler, HttpServletRequest request) {
        try {
            this.ruleServiceAdminStub.uploadRuleFile(serviceName, fileName, dataHandler);
            RuleService ruleService = this.getRuleServiceDescription(request);
            if (ruleService != null) {
                ruleService.setExtension("aar");
            }
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error uploading rule script : " + fileName);
        }
    }

    public String[] getRuleFileList(RuleService ruleService, HttpSession session) {
        String serviceName = ruleService.getName();
        String fname = "temp";
        try {
            String[] ruleFileList = this.ruleServiceAdminStub.getRuleFileList(serviceName, fname);
            return ruleFileList;
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error getting all rule files for rule service : " + serviceName);
        }
    }

    public void deleteRuleFile(RuleService ruleService, String fileName, HttpSession session) {
        String serviceName = ruleService.getName();
        try {
            this.ruleServiceAdminStub.deleteRuleFile(serviceName, fileName);
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error getting all rule files for rule service : " + serviceName);
        }
    }

    public String[] getAllFacts(RuleService ruleService, HttpSession session) {
        String serviceName = ruleService.getName();
        try {
            String[] facts = this.ruleServiceAdminStub.getAllFacts(ruleService.getExtension(), serviceName);
            session.setAttribute(serviceName.trim(), (Object)facts);
            return facts;
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error getting all facts for rule service : " + serviceName);
        }
    }

    public String[] getFactArchiveList(RuleService ruleService, HttpSession session) {
        String serviceName = ruleService.getName();
        try {
            String[] archiveList = this.ruleServiceAdminStub.getFactArchiveList(serviceName);
            session.setAttribute("allArchives", (Object)archiveList);
            return archiveList;
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error getting all facts archives for rule service : " + serviceName);
        }
    }

    public void deleteFactArchive(RuleService ruleService, String fileName, HttpSession session) {
        String serviceName = ruleService.getName();
        try {
            this.ruleServiceAdminStub.deleteFactArchive(serviceName, fileName);
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error deleting fact archive : " + fileName + "  rule service : " + serviceName);
        }
    }

    public void saveService(RuleService ruleService) {
        String serviceName = ruleService.getName();
        OMElement result = ruleService.toOM();
        if (!ruleService.isEditable()) {
            try {
                this.ruleServiceAdminStub.editRuleService(ruleService.getExtension(), serviceName, result);
            }
            catch (Exception e) {
                throw new RuleServiceClientException("Error editing rule service : " + serviceName);
            }
        }
        try {
            this.ruleServiceAdminStub.addRuleService(ruleService.getExtension(), serviceName, result);
        }
        catch (Exception e) {
            throw new RuleServiceClientException("Error adding a new rule service : " + serviceName);
        }
    }

    public RuleService getRuleService(String name) {
        try {
            OMElement omElement = this.ruleServiceAdminStub.getRuleService(name).getExtraElement();
            RuleService ruleService = RuleServiceHelper.getRuleService((OMElement)omElement);
            ruleService.setEditable(false);
            return ruleService;
        }
        catch (RemoteException e) {
            throw new RuleServiceClientException("Error retrieving rule service from name : " + name);
        }
        catch (RuleServiceAdminRuleServiceAdminException e) {
            throw new RuleServiceClientException("Error accessing stub rule service from name : " + name);
        }
        catch (RuleConfigurationException e) {
            throw new RuleServiceClientException("Error creating configuration rule service from name : " + name);
        }
    }
}

