/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.rule.common.Rule;

public class RuleSet {
    private List<Rule> rules = new ArrayList<Rule>();
    private String bindURI;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> registrationProperties;
    private Map<String, String> deregistrationProperties;

    public OMElement toOM() {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement ruleSetOMElement = omFactory.createOMElement("ruleSet", "http://wso2.org/carbon/rules", "brs");
        if (this.properties != null) {
            OMElement propertiesElement = omFactory.createOMElement("properties", "http://wso2.org/carbon/rules", "brs");
            for (String attName : this.properties.keySet()) {
                String attValue = this.properties.get(attName);
                OMElement propertyElement = omFactory.createOMElement("property", "http://wso2.org/carbon/rules", "brs");
                propertyElement.addAttribute("name", attName, null);
                propertyElement.addAttribute("value", attValue, null);
                propertiesElement.addChild((OMNode)propertyElement);
            }
            ruleSetOMElement.addChild((OMNode)propertiesElement);
        }
        for (Rule rule : this.rules) {
            ruleSetOMElement.addChild((OMNode)rule.toOM());
        }
        return ruleSetOMElement;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void clearRules() {
        this.rules.clear();
    }

    public String getBindURI() {
        return this.bindURI;
    }

    public void setBindURI(String bindURI) {
        this.bindURI = bindURI;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getRegistrationProperties() {
        return this.registrationProperties;
    }

    public void setRegistrationProperties(Map<String, String> registrationProperties) {
        this.registrationProperties = registrationProperties;
    }

    public Map<String, String> getDeregistrationProperties() {
        return this.deregistrationProperties;
    }

    public void setDeregistrationProperties(Map<String, String> deregistrationProperties) {
        this.deregistrationProperties = deregistrationProperties;
    }

    public void addProperties(String atName, String atValue) {
        this.properties.put(atName, atValue);
    }
}

