/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.ws.admin.AbstractRuleServiceAdminHandler;
import org.wso2.carbon.rule.ws.admin.Paths;
import org.wso2.carbon.rule.ws.admin.exception.RuleServiceAdminException;
import org.wso2.carbon.utils.FileManipulator;

public class RuleServiceFileAdminHandler
extends AbstractRuleServiceAdminHandler {
    @Override
    public void saveRuleService(AxisConfiguration axisConfiguration, AxisService axisService, RuleService ruleService) throws RuleServiceAdminException {
        String serviceName = ruleService.getName();
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File ruleFile = new File(paths.getWorkingDirPath());
        try {
            FileOutputStream os = new FileOutputStream(ruleFile);
            ruleService.toOM().serialize((OutputStream)os);
        }
        catch (Exception e) {
            throw new RuleServiceAdminException("Cannot write rule services XML", e);
        }
        try {
            FileManipulator.copyFile((File)new File(paths.getWorkingDirPath()), (File)new File(paths.getServicePath()));
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Error coping content of the  file : " + paths.getWorkingDirPath() + ". to the target file : " + paths.getServicePath());
        }
        this.cleanUp(paths);
    }

    @Override
    public OMElement getRuleService(AxisConfiguration axisConfiguration, String name) throws RuleServiceAdminException {
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, name);
        File ruleFile = new File(paths.getWorkingDirPath());
        return this.createXML(name, ruleFile);
    }

    @Override
    public String[] uploadFacts(AxisConfiguration axisConfiguration, String serviceName, String fileName, DataHandler dataHandler) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void uploadRuleFile(AxisConfiguration axisConfiguration, String serviceName, String fileName, DataHandler dataHandler) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public String[] getAllFacts(AxisConfiguration axisConfiguration, String serviceName) {
        ArrayList facts = new ArrayList();
        return facts.toArray(new String[facts.size()]);
    }

    @Override
    public String[] getFactArchiveList(AxisConfiguration axisConfiguration, String serviceName) {
        ArrayList factArchives = new ArrayList();
        return factArchives.toArray(new String[factArchives.size()]);
    }

    @Override
    public void deleteFactArchive(AxisConfiguration axisConfiguration, String serviceName, String fileName) throws RuleServiceAdminException {
    }

    @Override
    public String[] getRuleFileList(AxisConfiguration axisConfiguration, String serviceName, String fileName) throws RuleServiceAdminException {
        return new String[0];
    }

    @Override
    public void deleteRuleFile(AxisConfiguration axisConfiguration, String serviceName, String fileName) throws RuleServiceAdminException {
    }

    private Paths createTempRuleServiceFile(AxisConfiguration axisConfig, String serviceName) throws RuleServiceAdminException {
        String servicesDir = this.createServiceRepository(axisConfig);
        String servicePath = this.getServicePath(axisConfig, serviceName);
        String suffix = File.separator + serviceName + "." + "rsl";
        if (servicePath == null) {
            servicePath = servicesDir + suffix;
        }
        String targetDirectory = this.getTempDir() + suffix;
        File sourceFile = new File(servicePath);
        File rlsFile = new File(targetDirectory);
        File absoluteFile = rlsFile.getAbsoluteFile();
        if (absoluteFile.exists()) {
            absoluteFile.delete();
        }
        try {
            rlsFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Error creating a new file : " + rlsFile);
        }
        if (sourceFile.exists()) {
            try {
                FileManipulator.copyFile((File)sourceFile, (File)absoluteFile);
            }
            catch (IOException e) {
                throw new RuleServiceAdminException("Error coping content of the  file : " + sourceFile + ". to the target file : " + rlsFile);
            }
        }
        return new Paths(servicePath, targetDirectory);
    }
}

