/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.common.config;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.rule.common.Operation;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.common.config.HelperUtil;
import org.wso2.carbon.rule.common.config.OperationHelper;
import org.wso2.carbon.rule.common.config.RuleSetHelper;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;

public class RuleServiceHelper {
    public static RuleService getRuleService(OMElement ruleServiceElement) throws RuleConfigurationException {
        if (!ruleServiceElement.getQName().equals(new QName("http://wso2.org/carbon/rules", "ruleService"))) {
            throw new RuleConfigurationException("Invalid rule service configuration file");
        }
        RuleService ruleService = new RuleService();
        ruleService.setName(HelperUtil.getAttributeValue(ruleServiceElement, "name"));
        ruleService.setTargetNamespace(HelperUtil.getAttributeValue(ruleServiceElement, "targetNamespace"));
        ruleService.setScope(HelperUtil.getAttributeValue(ruleServiceElement, "scope"));
        ruleService.setDescription(HelperUtil.getAttributeValue(ruleServiceElement, "description"));
        OMElement ruleSetOMElement = ruleServiceElement.getFirstChildWithName(new QName("http://wso2.org/carbon/rules", "ruleSet"));
        if (ruleSetOMElement == null) {
            throw new RuleConfigurationException("No rule set is defined");
        }
        ruleService.setRuleSet(RuleSetHelper.getRuleSet(ruleSetOMElement));
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Iterator operationIter = ruleServiceElement.getChildrenWithName(new QName("http://wso2.org/carbon/rules", "operation"));
        while (operationIter.hasNext()) {
            OMElement operationElement = (OMElement)operationIter.next();
            operations.add(OperationHelper.getOperation(operationElement));
        }
        ruleService.setOperations(operations);
        return ruleService;
    }
}

